/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SeverityLabel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Severity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Severity> {
    private static final SdkField<Double> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Severity.getter(Severity::product)).setter(Severity.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Severity.getter(Severity::labelAsString)).setter(Severity.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<Integer> NORMALIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Severity.getter(Severity::normalized)).setter(Severity.setter(Builder::normalized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normalized").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_FIELD, LABEL_FIELD, NORMALIZED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double product;
    private final String label;
    private final Integer normalized;

    private Severity(BuilderImpl builder) {
        this.product = builder.product;
        this.label = builder.label;
        this.normalized = builder.normalized;
    }

    public Double product() {
        return this.product;
    }

    public SeverityLabel label() {
        return SeverityLabel.fromValue(this.label);
    }

    public String labelAsString() {
        return this.label;
    }

    public Integer normalized() {
        return this.normalized;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.normalized());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity)obj;
        return Objects.equals(this.product(), other.product()) && Objects.equals(this.labelAsString(), other.labelAsString()) && Objects.equals(this.normalized(), other.normalized());
    }

    public String toString() {
        return ToString.builder((String)"Severity").add("Product", (Object)this.product()).add("Label", (Object)this.labelAsString()).add("Normalized", (Object)this.normalized()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.labelAsString()));
            }
            case "Normalized": {
                return Optional.ofNullable(clazz.cast(this.normalized()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Severity, T> g) {
        return obj -> g.apply((Severity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double product;
        private String label;
        private Integer normalized;

        private BuilderImpl() {
        }

        private BuilderImpl(Severity model) {
            this.product(model.product);
            this.label(model.label);
            this.normalized(model.normalized);
        }

        public final Double getProduct() {
            return this.product;
        }

        @Override
        public final Builder product(Double product) {
            this.product = product;
            return this;
        }

        public final void setProduct(Double product) {
            this.product = product;
        }

        public final String getLabelAsString() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public final Builder label(SeverityLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Integer getNormalized() {
            return this.normalized;
        }

        @Override
        public final Builder normalized(Integer normalized) {
            this.normalized = normalized;
            return this;
        }

        public final void setNormalized(Integer normalized) {
            this.normalized = normalized;
        }

        public Severity build() {
            return new Severity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Severity> {
        public Builder product(Double var1);

        public Builder label(String var1);

        public Builder label(SeverityLabel var1);

        public Builder normalized(Integer var1);
    }
}

