/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Insight;
import software.amazon.awssdk.services.securityhub.model.InsightListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetInsightsResponse> {
    private static final SdkField<List<Insight>> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetInsightsResponse.getter(GetInsightsResponse::insights)).setter(GetInsightsResponse.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Insight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetInsightsResponse.getter(GetInsightsResponse::nextToken)).setter(GetInsightsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Insight> insights;
    private final String nextToken;

    private GetInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.insights = builder.insights;
        this.nextToken = builder.nextToken;
    }

    public boolean hasInsights() {
        return this.insights != null && !(this.insights instanceof SdkAutoConstructList);
    }

    public List<Insight> insights() {
        return this.insights;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.insights());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightsResponse)) {
            return false;
        }
        GetInsightsResponse other = (GetInsightsResponse)((Object)obj);
        return Objects.equals(this.insights(), other.insights()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetInsightsResponse").add("Insights", this.insights()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightsResponse, T> g) {
        return obj -> g.apply((GetInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Insight> insights = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightsResponse model) {
            super(model);
            this.insights(model.insights);
            this.nextToken(model.nextToken);
        }

        public final Collection<Insight.Builder> getInsights() {
            return this.insights != null ? (Collection)this.insights.stream().map(Insight::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insights(Collection<Insight> insights) {
            this.insights = InsightListCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Insight ... insights) {
            this.insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<Insight.Builder> ... insights) {
            this.insights(Stream.of(insights).map(c -> (Insight)((Insight.Builder)Insight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInsights(Collection<Insight.BuilderImpl> insights) {
            this.insights = InsightListCopier.copyFromBuilder(insights);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInsightsResponse build() {
            return new GetInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightsResponse> {
        public Builder insights(Collection<Insight> var1);

        public Builder insights(Insight ... var1);

        public Builder insights(Consumer<Insight.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

