/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionStagesTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecretVersionsListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecretVersionsListEntry> {
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SecretVersionsListEntry.getter(SecretVersionsListEntry::versionId)).setter(SecretVersionsListEntry.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<List<String>> VERSION_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SecretVersionsListEntry.getter(SecretVersionsListEntry::versionStages)).setter(SecretVersionsListEntry.setter(Builder::versionStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_ACCESSED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SecretVersionsListEntry.getter(SecretVersionsListEntry::lastAccessedDate)).setter(SecretVersionsListEntry.setter(Builder::lastAccessedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedDate").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SecretVersionsListEntry.getter(SecretVersionsListEntry::createdDate)).setter(SecretVersionsListEntry.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_ID_FIELD, VERSION_STAGES_FIELD, LAST_ACCESSED_DATE_FIELD, CREATED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String versionId;
    private final List<String> versionStages;
    private final Instant lastAccessedDate;
    private final Instant createdDate;

    private SecretVersionsListEntry(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.versionStages = builder.versionStages;
        this.lastAccessedDate = builder.lastAccessedDate;
        this.createdDate = builder.createdDate;
    }

    public String versionId() {
        return this.versionId;
    }

    public List<String> versionStages() {
        return this.versionStages;
    }

    public Instant lastAccessedDate() {
        return this.lastAccessedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStages());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretVersionsListEntry)) {
            return false;
        }
        SecretVersionsListEntry other = (SecretVersionsListEntry)obj;
        return Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.versionStages(), other.versionStages()) && Objects.equals(this.lastAccessedDate(), other.lastAccessedDate()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public String toString() {
        return ToString.builder((String)"SecretVersionsListEntry").add("VersionId", (Object)this.versionId()).add("VersionStages", this.versionStages()).add("LastAccessedDate", (Object)this.lastAccessedDate()).add("CreatedDate", (Object)this.createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "VersionStages": {
                return Optional.ofNullable(clazz.cast(this.versionStages()));
            }
            case "LastAccessedDate": {
                return Optional.ofNullable(clazz.cast(this.lastAccessedDate()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecretVersionsListEntry, T> g) {
        return obj -> g.apply((SecretVersionsListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String versionId;
        private List<String> versionStages = DefaultSdkAutoConstructList.getInstance();
        private Instant lastAccessedDate;
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SecretVersionsListEntry model) {
            this.versionId(model.versionId);
            this.versionStages(model.versionStages);
            this.lastAccessedDate(model.lastAccessedDate);
            this.createdDate(model.createdDate);
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<String> getVersionStages() {
            return this.versionStages;
        }

        @Override
        public final Builder versionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionStages(String ... versionStages) {
            this.versionStages(Arrays.asList(versionStages));
            return this;
        }

        public final void setVersionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
        }

        public final Instant getLastAccessedDate() {
            return this.lastAccessedDate;
        }

        @Override
        public final Builder lastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
            return this;
        }

        public final void setLastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public SecretVersionsListEntry build() {
            return new SecretVersionsListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecretVersionsListEntry> {
        public Builder versionId(String var1);

        public Builder versionStages(Collection<String> var1);

        public Builder versionStages(String ... var1);

        public Builder lastAccessedDate(Instant var1);

        public Builder createdDate(Instant var1);
    }
}

