/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSecretValueRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<GetSecretValueRequest.Builder, GetSecretValueRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(GetSecretValueRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(GetSecretValueRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> VERSION_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionStage").getter(getter(GetSecretValueRequest::versionStage)).setter(setter(Builder::versionStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            VERSION_ID_FIELD, VERSION_STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String secretId;

    private final String versionId;

    private final String versionStage;

    private GetSecretValueRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.versionId = builder.versionId;
        this.versionStage = builder.versionStage;
    }

    /**
     * <p>
     * The ARN or name of the secret to retrieve. To retrieve a secret from another account, you must use an ARN.
     * </p>
     * <p>
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen">Finding
     * a secret from a partial ARN</a>.
     * </p>
     * 
     * @return The ARN or name of the secret to retrieve. To retrieve a secret from another account, you must use an
     *         ARN.</p>
     *         <p>
     *         For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
     *         "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
     *         >Finding a secret from a partial ARN</a>.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * <p>
     * The unique identifier of the version of the secret to retrieve. If you include both this parameter and
     * <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify either
     * a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the <code>AWSCURRENT</code>
     * version.
     * </p>
     * <p>
     * This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value
     * with 32 hexadecimal digits.
     * </p>
     * 
     * @return The unique identifier of the version of the secret to retrieve. If you include both this parameter and
     *         <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify
     *         either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the
     *         <code>AWSCURRENT</code> version.</p>
     *         <p>
     *         This value is typically a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal
     *         digits.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The staging label of the version of the secret to retrieve.
     * </p>
     * <p>
     * Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you
     * include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version.
     * If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager returns the
     * <code>AWSCURRENT</code> version.
     * </p>
     * 
     * @return The staging label of the version of the secret to retrieve. </p>
     *         <p>
     *         Secrets Manager uses staging labels to keep track of different versions during the rotation process. If
     *         you include both this parameter and <code>VersionId</code>, the two parameters must refer to the same
     *         secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>,
     *         Secrets Manager returns the <code>AWSCURRENT</code> version.
     */
    public final String versionStage() {
        return versionStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionStage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecretValueRequest)) {
            return false;
        }
        GetSecretValueRequest other = (GetSecretValueRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(versionStage(), other.versionStage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSecretValueRequest").add("SecretId", secretId()).add("VersionId", versionId())
                .add("VersionStage", versionStage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "VersionStage":
            return Optional.ofNullable(clazz.cast(versionStage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretId", SECRET_ID_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("VersionStage", VERSION_STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSecretValueRequest, T> g) {
        return obj -> g.apply((GetSecretValueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSecretValueRequest> {
        /**
         * <p>
         * The ARN or name of the secret to retrieve. To retrieve a secret from another account, you must use an ARN.
         * </p>
         * <p>
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         * >Finding a secret from a partial ARN</a>.
         * </p>
         * 
         * @param secretId
         *        The ARN or name of the secret to retrieve. To retrieve a secret from another account, you must use an
         *        ARN.</p>
         *        <p>
         *        For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
         *        "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         *        >Finding a secret from a partial ARN</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * The unique identifier of the version of the secret to retrieve. If you include both this parameter and
         * <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify
         * either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the
         * <code>AWSCURRENT</code> version.
         * </p>
         * <p>
         * This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a>
         * value with 32 hexadecimal digits.
         * </p>
         * 
         * @param versionId
         *        The unique identifier of the version of the secret to retrieve. If you include both this parameter and
         *        <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't
         *        specify either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the
         *        <code>AWSCURRENT</code> version.</p>
         *        <p>
         *        This value is typically a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32
         *        hexadecimal digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The staging label of the version of the secret to retrieve.
         * </p>
         * <p>
         * Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you
         * include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret
         * version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager
         * returns the <code>AWSCURRENT</code> version.
         * </p>
         * 
         * @param versionStage
         *        The staging label of the version of the secret to retrieve. </p>
         *        <p>
         *        Secrets Manager uses staging labels to keep track of different versions during the rotation process.
         *        If you include both this parameter and <code>VersionId</code>, the two parameters must refer to the
         *        same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>
         *        , Secrets Manager returns the <code>AWSCURRENT</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStage(String versionStage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String versionId;

        private String versionStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecretValueRequest model) {
            super(model);
            secretId(model.secretId);
            versionId(model.versionId);
            versionStage(model.versionStage);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getVersionStage() {
            return versionStage;
        }

        public final void setVersionStage(String versionStage) {
            this.versionStage = versionStage;
        }

        @Override
        public final Builder versionStage(String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSecretValueRequest build() {
            return new GetSecretValueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
