/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(PutResourcePolicyRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(PutResourcePolicyRequest::resourcePolicy))
            .setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BlockPublicPolicy").getter(getter(PutResourcePolicyRequest::blockPublicPolicy))
            .setter(setter(Builder::blockPublicPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            RESOURCE_POLICY_FIELD, BLOCK_PUBLIC_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String secretId;

    private final String resourcePolicy;

    private final Boolean blockPublicPolicy;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.resourcePolicy = builder.resourcePolicy;
        this.blockPublicPolicy = builder.blockPublicPolicy;
    }

    /**
     * <p>
     * The ARN or name of the secret to attach the resource-based policy.
     * </p>
     * <p>
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen">Finding
     * a secret from a partial ARN</a>.
     * </p>
     * 
     * @return The ARN or name of the secret to attach the resource-based policy.</p>
     *         <p>
     *         For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
     *         "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
     *         >Finding a secret from a partial ARN</a>.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * <p>
     * A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions
     * policy examples</a>.
     * </p>
     * 
     * @return A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a
     *         href
     *         ="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions
     *         policy examples</a>.
     */
    public final String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * Specifies whether to block resource-based policies that allow broad access to the secret, for example those that
     * use a wildcard for the principal. By default, public policies aren't blocked.
     * </p>
     * <important>
     * <p>
     * Resource policy validation and the BlockPublicPolicy parameter help protect your resources by preventing public
     * access from being granted through the resource policies that are directly attached to your secrets. In addition
     * to using these features, carefully inspect the following policies to confirm that they do not grant public
     * access:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Identity-based policies attached to associated Amazon Web Services principals (for example, IAM roles)
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource-based policies attached to associated Amazon Web Services resources (for example, Key Management Service
     * (KMS) keys)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To review permissions to your secrets, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/determine-acccess_examine-iam-policies.html"
     * >Determine who has permissions to your secrets</a>.
     * </p>
     * </important>
     * 
     * @return Specifies whether to block resource-based policies that allow broad access to the secret, for example
     *         those that use a wildcard for the principal. By default, public policies aren't blocked.</p> <important>
     *         <p>
     *         Resource policy validation and the BlockPublicPolicy parameter help protect your resources by preventing
     *         public access from being granted through the resource policies that are directly attached to your
     *         secrets. In addition to using these features, carefully inspect the following policies to confirm that
     *         they do not grant public access:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Identity-based policies attached to associated Amazon Web Services principals (for example, IAM roles)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resource-based policies attached to associated Amazon Web Services resources (for example, Key Management
     *         Service (KMS) keys)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To review permissions to your secrets, see <a href=
     *         "https://docs.aws.amazon.com/secretsmanager/latest/userguide/determine-acccess_examine-iam-policies.html"
     *         >Determine who has permissions to your secrets</a>.
     *         </p>
     */
    public final Boolean blockPublicPolicy() {
        return blockPublicPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(resourcePolicy(), other.resourcePolicy())
                && Objects.equals(blockPublicPolicy(), other.blockPublicPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("SecretId", secretId()).add("ResourcePolicy", resourcePolicy())
                .add("BlockPublicPolicy", blockPublicPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "BlockPublicPolicy":
            return Optional.ofNullable(clazz.cast(blockPublicPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretId", SECRET_ID_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("BlockPublicPolicy", BLOCK_PUBLIC_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * The ARN or name of the secret to attach the resource-based policy.
         * </p>
         * <p>
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         * >Finding a secret from a partial ARN</a>.
         * </p>
         * 
         * @param secretId
         *        The ARN or name of the secret to attach the resource-based policy.</p>
         *        <p>
         *        For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
         *        "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         *        >Finding a secret from a partial ARN</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions
         * policy examples</a>.
         * </p>
         * 
         * @param resourcePolicy
         *        A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">
         *        Permissions policy examples</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * Specifies whether to block resource-based policies that allow broad access to the secret, for example those
         * that use a wildcard for the principal. By default, public policies aren't blocked.
         * </p>
         * <important>
         * <p>
         * Resource policy validation and the BlockPublicPolicy parameter help protect your resources by preventing
         * public access from being granted through the resource policies that are directly attached to your secrets. In
         * addition to using these features, carefully inspect the following policies to confirm that they do not grant
         * public access:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Identity-based policies attached to associated Amazon Web Services principals (for example, IAM roles)
         * </p>
         * </li>
         * <li>
         * <p>
         * Resource-based policies attached to associated Amazon Web Services resources (for example, Key Management
         * Service (KMS) keys)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To review permissions to your secrets, see <a href=
         * "https://docs.aws.amazon.com/secretsmanager/latest/userguide/determine-acccess_examine-iam-policies.html"
         * >Determine who has permissions to your secrets</a>.
         * </p>
         * </important>
         * 
         * @param blockPublicPolicy
         *        Specifies whether to block resource-based policies that allow broad access to the secret, for example
         *        those that use a wildcard for the principal. By default, public policies aren't blocked.</p>
         *        <important>
         *        <p>
         *        Resource policy validation and the BlockPublicPolicy parameter help protect your resources by
         *        preventing public access from being granted through the resource policies that are directly attached
         *        to your secrets. In addition to using these features, carefully inspect the following policies to
         *        confirm that they do not grant public access:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Identity-based policies attached to associated Amazon Web Services principals (for example, IAM roles)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resource-based policies attached to associated Amazon Web Services resources (for example, Key
         *        Management Service (KMS) keys)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To review permissions to your secrets, see <a href=
         *        "https://docs.aws.amazon.com/secretsmanager/latest/userguide/determine-acccess_examine-iam-policies.html"
         *        >Determine who has permissions to your secrets</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicPolicy(Boolean blockPublicPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String resourcePolicy;

        private Boolean blockPublicPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            secretId(model.secretId);
            resourcePolicy(model.resourcePolicy);
            blockPublicPolicy(model.blockPublicPolicy);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final Boolean getBlockPublicPolicy() {
            return blockPublicPolicy;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
