/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRandomPasswordRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<GetRandomPasswordRequest.Builder, GetRandomPasswordRequest> {
    private static final SdkField<Long> PASSWORD_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PasswordLength").getter(getter(GetRandomPasswordRequest::passwordLength))
            .setter(setter(Builder::passwordLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordLength").build()).build();

    private static final SdkField<String> EXCLUDE_CHARACTERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExcludeCharacters").getter(getter(GetRandomPasswordRequest::excludeCharacters))
            .setter(setter(Builder::excludeCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCharacters").build()).build();

    private static final SdkField<Boolean> EXCLUDE_NUMBERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeNumbers").getter(getter(GetRandomPasswordRequest::excludeNumbers))
            .setter(setter(Builder::excludeNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeNumbers").build()).build();

    private static final SdkField<Boolean> EXCLUDE_PUNCTUATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludePunctuation").getter(getter(GetRandomPasswordRequest::excludePunctuation))
            .setter(setter(Builder::excludePunctuation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePunctuation").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_UPPERCASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeUppercase").getter(getter(GetRandomPasswordRequest::excludeUppercase))
            .setter(setter(Builder::excludeUppercase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeUppercase").build()).build();

    private static final SdkField<Boolean> EXCLUDE_LOWERCASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeLowercase").getter(getter(GetRandomPasswordRequest::excludeLowercase))
            .setter(setter(Builder::excludeLowercase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeLowercase").build()).build();

    private static final SdkField<Boolean> INCLUDE_SPACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeSpace").getter(getter(GetRandomPasswordRequest::includeSpace))
            .setter(setter(Builder::includeSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeSpace").build()).build();

    private static final SdkField<Boolean> REQUIRE_EACH_INCLUDED_TYPE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireEachIncludedType").getter(getter(GetRandomPasswordRequest::requireEachIncludedType))
            .setter(setter(Builder::requireEachIncludedType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireEachIncludedType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_LENGTH_FIELD,
            EXCLUDE_CHARACTERS_FIELD, EXCLUDE_NUMBERS_FIELD, EXCLUDE_PUNCTUATION_FIELD, EXCLUDE_UPPERCASE_FIELD,
            EXCLUDE_LOWERCASE_FIELD, INCLUDE_SPACE_FIELD, REQUIRE_EACH_INCLUDED_TYPE_FIELD));

    private final Long passwordLength;

    private final String excludeCharacters;

    private final Boolean excludeNumbers;

    private final Boolean excludePunctuation;

    private final Boolean excludeUppercase;

    private final Boolean excludeLowercase;

    private final Boolean includeSpace;

    private final Boolean requireEachIncludedType;

    private GetRandomPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.passwordLength = builder.passwordLength;
        this.excludeCharacters = builder.excludeCharacters;
        this.excludeNumbers = builder.excludeNumbers;
        this.excludePunctuation = builder.excludePunctuation;
        this.excludeUppercase = builder.excludeUppercase;
        this.excludeLowercase = builder.excludeLowercase;
        this.includeSpace = builder.includeSpace;
        this.requireEachIncludedType = builder.requireEachIncludedType;
    }

    /**
     * <p>
     * The length of the password. If you don't include this parameter, the default length is 32 characters.
     * </p>
     * 
     * @return The length of the password. If you don't include this parameter, the default length is 32 characters.
     */
    public final Long passwordLength() {
        return passwordLength;
    }

    /**
     * <p>
     * A string of the characters that you don't want in the password.
     * </p>
     * 
     * @return A string of the characters that you don't want in the password.
     */
    public final String excludeCharacters() {
        return excludeCharacters;
    }

    /**
     * <p>
     * Specifies whether to exclude numbers from the password. If you don't include this switch, the password can
     * contain numbers.
     * </p>
     * 
     * @return Specifies whether to exclude numbers from the password. If you don't include this switch, the password
     *         can contain numbers.
     */
    public final Boolean excludeNumbers() {
        return excludeNumbers;
    }

    /**
     * <p>
     * Specifies whether to exclude the following punctuation characters from the password:
     * <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include this
     * switch, the password can contain punctuation.
     * </p>
     * 
     * @return Specifies whether to exclude the following punctuation characters from the password:
     *         <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't
     *         include this switch, the password can contain punctuation.
     */
    public final Boolean excludePunctuation() {
        return excludePunctuation;
    }

    /**
     * <p>
     * Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password
     * can contain uppercase letters.
     * </p>
     * 
     * @return Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the
     *         password can contain uppercase letters.
     */
    public final Boolean excludeUppercase() {
        return excludeUppercase;
    }

    /**
     * <p>
     * Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password
     * can contain lowercase letters.
     * </p>
     * 
     * @return Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the
     *         password can contain lowercase letters.
     */
    public final Boolean excludeLowercase() {
        return excludeLowercase;
    }

    /**
     * <p>
     * Specifies whether to include the space character. If you include this switch, the password can contain space
     * characters.
     * </p>
     * 
     * @return Specifies whether to include the space character. If you include this switch, the password can contain
     *         space characters.
     */
    public final Boolean includeSpace() {
        return includeSpace;
    }

    /**
     * <p>
     * Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you
     * don't include this switch, the password contains at least one of every character type.
     * </p>
     * 
     * @return Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If
     *         you don't include this switch, the password contains at least one of every character type.
     */
    public final Boolean requireEachIncludedType() {
        return requireEachIncludedType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(passwordLength());
        hashCode = 31 * hashCode + Objects.hashCode(excludeCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(excludeNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(excludePunctuation());
        hashCode = 31 * hashCode + Objects.hashCode(excludeUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(excludeLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(includeSpace());
        hashCode = 31 * hashCode + Objects.hashCode(requireEachIncludedType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRandomPasswordRequest)) {
            return false;
        }
        GetRandomPasswordRequest other = (GetRandomPasswordRequest) obj;
        return Objects.equals(passwordLength(), other.passwordLength())
                && Objects.equals(excludeCharacters(), other.excludeCharacters())
                && Objects.equals(excludeNumbers(), other.excludeNumbers())
                && Objects.equals(excludePunctuation(), other.excludePunctuation())
                && Objects.equals(excludeUppercase(), other.excludeUppercase())
                && Objects.equals(excludeLowercase(), other.excludeLowercase())
                && Objects.equals(includeSpace(), other.includeSpace())
                && Objects.equals(requireEachIncludedType(), other.requireEachIncludedType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRandomPasswordRequest").add("PasswordLength", passwordLength())
                .add("ExcludeCharacters", excludeCharacters()).add("ExcludeNumbers", excludeNumbers())
                .add("ExcludePunctuation", excludePunctuation()).add("ExcludeUppercase", excludeUppercase())
                .add("ExcludeLowercase", excludeLowercase()).add("IncludeSpace", includeSpace())
                .add("RequireEachIncludedType", requireEachIncludedType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordLength":
            return Optional.ofNullable(clazz.cast(passwordLength()));
        case "ExcludeCharacters":
            return Optional.ofNullable(clazz.cast(excludeCharacters()));
        case "ExcludeNumbers":
            return Optional.ofNullable(clazz.cast(excludeNumbers()));
        case "ExcludePunctuation":
            return Optional.ofNullable(clazz.cast(excludePunctuation()));
        case "ExcludeUppercase":
            return Optional.ofNullable(clazz.cast(excludeUppercase()));
        case "ExcludeLowercase":
            return Optional.ofNullable(clazz.cast(excludeLowercase()));
        case "IncludeSpace":
            return Optional.ofNullable(clazz.cast(includeSpace()));
        case "RequireEachIncludedType":
            return Optional.ofNullable(clazz.cast(requireEachIncludedType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRandomPasswordRequest, T> g) {
        return obj -> g.apply((GetRandomPasswordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRandomPasswordRequest> {
        /**
         * <p>
         * The length of the password. If you don't include this parameter, the default length is 32 characters.
         * </p>
         * 
         * @param passwordLength
         *        The length of the password. If you don't include this parameter, the default length is 32 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordLength(Long passwordLength);

        /**
         * <p>
         * A string of the characters that you don't want in the password.
         * </p>
         * 
         * @param excludeCharacters
         *        A string of the characters that you don't want in the password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCharacters(String excludeCharacters);

        /**
         * <p>
         * Specifies whether to exclude numbers from the password. If you don't include this switch, the password can
         * contain numbers.
         * </p>
         * 
         * @param excludeNumbers
         *        Specifies whether to exclude numbers from the password. If you don't include this switch, the password
         *        can contain numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeNumbers(Boolean excludeNumbers);

        /**
         * <p>
         * Specifies whether to exclude the following punctuation characters from the password:
         * <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include
         * this switch, the password can contain punctuation.
         * </p>
         * 
         * @param excludePunctuation
         *        Specifies whether to exclude the following punctuation characters from the password:
         *        <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't
         *        include this switch, the password can contain punctuation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePunctuation(Boolean excludePunctuation);

        /**
         * <p>
         * Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the
         * password can contain uppercase letters.
         * </p>
         * 
         * @param excludeUppercase
         *        Specifies whether to exclude uppercase letters from the password. If you don't include this switch,
         *        the password can contain uppercase letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeUppercase(Boolean excludeUppercase);

        /**
         * <p>
         * Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the
         * password can contain lowercase letters.
         * </p>
         * 
         * @param excludeLowercase
         *        Specifies whether to exclude lowercase letters from the password. If you don't include this switch,
         *        the password can contain lowercase letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeLowercase(Boolean excludeLowercase);

        /**
         * <p>
         * Specifies whether to include the space character. If you include this switch, the password can contain space
         * characters.
         * </p>
         * 
         * @param includeSpace
         *        Specifies whether to include the space character. If you include this switch, the password can contain
         *        space characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSpace(Boolean includeSpace);

        /**
         * <p>
         * Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you
         * don't include this switch, the password contains at least one of every character type.
         * </p>
         * 
         * @param requireEachIncludedType
         *        Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
         *        If you don't include this switch, the password contains at least one of every character type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireEachIncludedType(Boolean requireEachIncludedType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private Long passwordLength;

        private String excludeCharacters;

        private Boolean excludeNumbers;

        private Boolean excludePunctuation;

        private Boolean excludeUppercase;

        private Boolean excludeLowercase;

        private Boolean includeSpace;

        private Boolean requireEachIncludedType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRandomPasswordRequest model) {
            super(model);
            passwordLength(model.passwordLength);
            excludeCharacters(model.excludeCharacters);
            excludeNumbers(model.excludeNumbers);
            excludePunctuation(model.excludePunctuation);
            excludeUppercase(model.excludeUppercase);
            excludeLowercase(model.excludeLowercase);
            includeSpace(model.includeSpace);
            requireEachIncludedType(model.requireEachIncludedType);
        }

        public final Long getPasswordLength() {
            return passwordLength;
        }

        public final void setPasswordLength(Long passwordLength) {
            this.passwordLength = passwordLength;
        }

        @Override
        public final Builder passwordLength(Long passwordLength) {
            this.passwordLength = passwordLength;
            return this;
        }

        public final String getExcludeCharacters() {
            return excludeCharacters;
        }

        public final void setExcludeCharacters(String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
        }

        @Override
        public final Builder excludeCharacters(String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        public final Boolean getExcludeNumbers() {
            return excludeNumbers;
        }

        public final void setExcludeNumbers(Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
        }

        @Override
        public final Builder excludeNumbers(Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
            return this;
        }

        public final Boolean getExcludePunctuation() {
            return excludePunctuation;
        }

        public final void setExcludePunctuation(Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
        }

        @Override
        public final Builder excludePunctuation(Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
            return this;
        }

        public final Boolean getExcludeUppercase() {
            return excludeUppercase;
        }

        public final void setExcludeUppercase(Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
        }

        @Override
        public final Builder excludeUppercase(Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
            return this;
        }

        public final Boolean getExcludeLowercase() {
            return excludeLowercase;
        }

        public final void setExcludeLowercase(Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
        }

        @Override
        public final Builder excludeLowercase(Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
            return this;
        }

        public final Boolean getIncludeSpace() {
            return includeSpace;
        }

        public final void setIncludeSpace(Boolean includeSpace) {
            this.includeSpace = includeSpace;
        }

        @Override
        public final Builder includeSpace(Boolean includeSpace) {
            this.includeSpace = includeSpace;
            return this;
        }

        public final Boolean getRequireEachIncludedType() {
            return requireEachIncludedType;
        }

        public final void setRequireEachIncludedType(Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
        }

        @Override
        public final Builder requireEachIncludedType(Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRandomPasswordRequest build() {
            return new GetRandomPasswordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
