/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A replication object consisting of a <code>RegionReplicationStatus</code> object and includes a Region, KMSKeyId,
 * status, and status message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationStatusType implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationStatusType.Builder, ReplicationStatusType> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ReplicationStatusType::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ReplicationStatusType::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReplicationStatusType::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ReplicationStatusType::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessedDate").getter(getter(ReplicationStatusType::lastAccessedDate))
            .setter(setter(Builder::lastAccessedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            KMS_KEY_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, LAST_ACCESSED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String kmsKeyId;

    private final String status;

    private final String statusMessage;

    private final Instant lastAccessedDate;

    private ReplicationStatusType(BuilderImpl builder) {
        this.region = builder.region;
        this.kmsKeyId = builder.kmsKeyId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.lastAccessedDate = builder.lastAccessedDate;
    }

    /**
     * <p>
     * The Region where replication occurs.
     * </p>
     * 
     * @return The Region where replication occurs.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>.
     * </p>
     * 
     * @return Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
     * @see StatusType
     */
    public final StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
     * @see StatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status message such as "<i>Secret with this name already exists in this region</i>".
     * </p>
     * 
     * @return Status message such as "<i>Secret with this name already exists in this region</i>".
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date that you last accessed the secret in the Region.
     * </p>
     * 
     * @return The date that you last accessed the secret in the Region.
     */
    public final Instant lastAccessedDate() {
        return lastAccessedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationStatusType)) {
            return false;
        }
        ReplicationStatusType other = (ReplicationStatusType) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(lastAccessedDate(), other.lastAccessedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationStatusType").add("Region", region()).add("KmsKeyId", kmsKeyId())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("LastAccessedDate", lastAccessedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "LastAccessedDate":
            return Optional.ofNullable(clazz.cast(lastAccessedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationStatusType, T> g) {
        return obj -> g.apply((ReplicationStatusType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationStatusType> {
        /**
         * <p>
         * The Region where replication occurs.
         * </p>
         * 
         * @param region
         *        The Region where replication occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>.
         * </p>
         * 
         * @param kmsKeyId
         *        Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
         * </p>
         * 
         * @param status
         *        The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
         * </p>
         * 
         * @param status
         *        The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);

        /**
         * <p>
         * Status message such as "<i>Secret with this name already exists in this region</i>".
         * </p>
         * 
         * @param statusMessage
         *        Status message such as "<i>Secret with this name already exists in this region</i>".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date that you last accessed the secret in the Region.
         * </p>
         * 
         * @param lastAccessedDate
         *        The date that you last accessed the secret in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedDate(Instant lastAccessedDate);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String kmsKeyId;

        private String status;

        private String statusMessage;

        private Instant lastAccessedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationStatusType model) {
            region(model.region);
            kmsKeyId(model.kmsKeyId);
            status(model.status);
            statusMessage(model.statusMessage);
            lastAccessedDate(model.lastAccessedDate);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getLastAccessedDate() {
            return lastAccessedDate;
        }

        public final void setLastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
        }

        @Override
        @Transient
        public final Builder lastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
            return this;
        }

        @Override
        public ReplicationStatusType build() {
            return new ReplicationStatusType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
