/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecretVersionIdsRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<ListSecretVersionIdsRequest.Builder, ListSecretVersionIdsRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSecretVersionIdsRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListSecretVersionIdsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSecretVersionIdsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Boolean> INCLUDE_DEPRECATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListSecretVersionIdsRequest::includeDeprecated)).setter(setter(Builder::includeDeprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeprecated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, INCLUDE_DEPRECATED_FIELD));

    private final String secretId;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean includeDeprecated;

    private ListSecretVersionIdsRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeDeprecated = builder.includeDeprecated;
    }

    /**
     * <p>
     * The identifier for the secret containing the versions you want to list. You can specify either the Amazon
     * Resource Name (ARN) or the friendly name of the secret.
     * </p>
     * <note>
     * <p>
     * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
     * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at the
     * end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches only one
     * secret. However, if your secret has a name that ends in a hyphen followed by six characters (before Secrets
     * Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then those
     * characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can cause
     * unexpected results. To avoid this situation, we recommend that you don’t create secret names that end with a
     * hyphen followed by six characters.
     * </p>
     * </note>
     * 
     * @return The identifier for the secret containing the versions you want to list. You can specify either the Amazon
     *         Resource Name (ARN) or the friendly name of the secret.</p> <note>
     *         <p>
     *         If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial
     *         ARN too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager
     *         adds at the end of the ARN when you created the secret. A partial ARN match can work as long as it
     *         uniquely matches only one secret. However, if your secret has a name that ends in a hyphen followed by
     *         six characters (before Secrets Manager adds the hyphen and six characters to the ARN) and you try to use
     *         that as a partial ARN, then those characters cause Secrets Manager to assume that you’re specifying a
     *         complete ARN. This confusion can cause unexpected results. To avoid this situation, we recommend that you
     *         don’t create secret names that end with a hyphen followed by six characters.
     *         </p>
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * (Optional) Limits the number of results that you want to include in the response. If you don't include this
     * parameter, it defaults to a value that's specific to the operation. If additional items exist beyond the maximum
     * you specify, the <code>NextToken</code> response element is present and has a value (isn't null). Include that
     * value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of
     * the results. Note that Secrets Manager might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return (Optional) Limits the number of results that you want to include in the response. If you don't include
     *         this parameter, it defaults to a value that's specific to the operation. If additional items exist beyond
     *         the maximum you specify, the <code>NextToken</code> response element is present and has a value (isn't
     *         null). Include that value as the <code>NextToken</code> request parameter in the next call to the
     *         operation to get the next part of the results. Note that Secrets Manager might return fewer results than
     *         the maximum even when there are more results available. You should check <code>NextToken</code> after
     *         every operation to ensure that you receive all of the results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous request
     * that indicates that there's more output available. In a subsequent call, set it to the value of the previous
     * call's <code>NextToken</code> response to indicate where the output should continue from.
     * </p>
     * 
     * @return (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous
     *         request that indicates that there's more output available. In a subsequent call, set it to the value of
     *         the previous call's <code>NextToken</code> response to indicate where the output should continue from.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * (Optional) Specifies that you want the results to include versions that do not have any staging labels attached
     * to them. Such versions are considered deprecated and are subject to deletion by Secrets Manager as needed.
     * </p>
     * 
     * @return (Optional) Specifies that you want the results to include versions that do not have any staging labels
     *         attached to them. Such versions are considered deprecated and are subject to deletion by Secrets Manager
     *         as needed.
     */
    public Boolean includeDeprecated() {
        return includeDeprecated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(includeDeprecated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretVersionIdsRequest)) {
            return false;
        }
        ListSecretVersionIdsRequest other = (ListSecretVersionIdsRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(includeDeprecated(), other.includeDeprecated());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSecretVersionIdsRequest").add("SecretId", secretId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("IncludeDeprecated", includeDeprecated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "IncludeDeprecated":
            return Optional.ofNullable(clazz.cast(includeDeprecated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecretVersionIdsRequest, T> g) {
        return obj -> g.apply((ListSecretVersionIdsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSecretVersionIdsRequest> {
        /**
         * <p>
         * The identifier for the secret containing the versions you want to list. You can specify either the Amazon
         * Resource Name (ARN) or the friendly name of the secret.
         * </p>
         * <note>
         * <p>
         * If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a partial ARN
         * too—for example, if you don’t include the final hyphen and six random characters that Secrets Manager adds at
         * the end of the ARN when you created the secret. A partial ARN match can work as long as it uniquely matches
         * only one secret. However, if your secret has a name that ends in a hyphen followed by six characters (before
         * Secrets Manager adds the hyphen and six characters to the ARN) and you try to use that as a partial ARN, then
         * those characters cause Secrets Manager to assume that you’re specifying a complete ARN. This confusion can
         * cause unexpected results. To avoid this situation, we recommend that you don’t create secret names that end
         * with a hyphen followed by six characters.
         * </p>
         * </note>
         * 
         * @param secretId
         *        The identifier for the secret containing the versions you want to list. You can specify either the
         *        Amazon Resource Name (ARN) or the friendly name of the secret.</p> <note>
         *        <p>
         *        If you specify an ARN, we generally recommend that you specify a complete ARN. You can specify a
         *        partial ARN too—for example, if you don’t include the final hyphen and six random characters that
         *        Secrets Manager adds at the end of the ARN when you created the secret. A partial ARN match can work
         *        as long as it uniquely matches only one secret. However, if your secret has a name that ends in a
         *        hyphen followed by six characters (before Secrets Manager adds the hyphen and six characters to the
         *        ARN) and you try to use that as a partial ARN, then those characters cause Secrets Manager to assume
         *        that you’re specifying a complete ARN. This confusion can cause unexpected results. To avoid this
         *        situation, we recommend that you don’t create secret names that end with a hyphen followed by six
         *        characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * (Optional) Limits the number of results that you want to include in the response. If you don't include this
         * parameter, it defaults to a value that's specific to the operation. If additional items exist beyond the
         * maximum you specify, the <code>NextToken</code> response element is present and has a value (isn't null).
         * Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get
         * the next part of the results. Note that Secrets Manager might return fewer results than the maximum even when
         * there are more results available. You should check <code>NextToken</code> after every operation to ensure
         * that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        (Optional) Limits the number of results that you want to include in the response. If you don't include
         *        this parameter, it defaults to a value that's specific to the operation. If additional items exist
         *        beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
         *        (isn't null). Include that value as the <code>NextToken</code> request parameter in the next call to
         *        the operation to get the next part of the results. Note that Secrets Manager might return fewer
         *        results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous
         * request that indicates that there's more output available. In a subsequent call, set it to the value of the
         * previous call's <code>NextToken</code> response to indicate where the output should continue from.
         * </p>
         * 
         * @param nextToken
         *        (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a
         *        previous request that indicates that there's more output available. In a subsequent call, set it to
         *        the value of the previous call's <code>NextToken</code> response to indicate where the output should
         *        continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) Specifies that you want the results to include versions that do not have any staging labels
         * attached to them. Such versions are considered deprecated and are subject to deletion by Secrets Manager as
         * needed.
         * </p>
         * 
         * @param includeDeprecated
         *        (Optional) Specifies that you want the results to include versions that do not have any staging labels
         *        attached to them. Such versions are considered deprecated and are subject to deletion by Secrets
         *        Manager as needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDeprecated(Boolean includeDeprecated);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private Integer maxResults;

        private String nextToken;

        private Boolean includeDeprecated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretVersionIdsRequest model) {
            super(model);
            secretId(model.secretId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            includeDeprecated(model.includeDeprecated);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getIncludeDeprecated() {
            return includeDeprecated;
        }

        @Override
        public final Builder includeDeprecated(Boolean includeDeprecated) {
            this.includeDeprecated = includeDeprecated;
            return this;
        }

        public final void setIncludeDeprecated(Boolean includeDeprecated) {
            this.includeDeprecated = includeDeprecated;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSecretVersionIdsRequest build() {
            return new ListSecretVersionIdsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
