/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetRandomPasswordRequestModelMarshaller {
    private static final MarshallingInfo<Long> PASSWORDLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PasswordLength").isBinary(false).build();
    private static final MarshallingInfo<String> EXCLUDECHARACTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeCharacters").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EXCLUDENUMBERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeNumbers").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EXCLUDEPUNCTUATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludePunctuation").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EXCLUDEUPPERCASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeUppercase").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EXCLUDELOWERCASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeLowercase").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeSpace").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIREEACHINCLUDEDTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequireEachIncludedType").isBinary(false).build();
    private static final GetRandomPasswordRequestModelMarshaller INSTANCE = new GetRandomPasswordRequestModelMarshaller();

    private GetRandomPasswordRequestModelMarshaller() {
    }

    public static GetRandomPasswordRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetRandomPasswordRequest getRandomPasswordRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getRandomPasswordRequest), (String)"getRandomPasswordRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.passwordLength(), PASSWORDLENGTH_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.excludeCharacters(), EXCLUDECHARACTERS_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.excludeNumbers(), EXCLUDENUMBERS_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.excludePunctuation(), EXCLUDEPUNCTUATION_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.excludeUppercase(), EXCLUDEUPPERCASE_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.excludeLowercase(), EXCLUDELOWERCASE_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.includeSpace(), INCLUDESPACE_BINDING);
            protocolMarshaller.marshall((Object)getRandomPasswordRequest.requireEachIncludedType(), REQUIREEACHINCLUDEDTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

