/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecretVersionIdsRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, ListSecretVersionIdsRequest> {
    private final String secretId;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean includeDeprecated;

    private ListSecretVersionIdsRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeDeprecated = builder.includeDeprecated;
    }

    public String secretId() {
        return this.secretId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Boolean includeDeprecated() {
        return this.includeDeprecated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeDeprecated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretVersionIdsRequest)) {
            return false;
        }
        ListSecretVersionIdsRequest other = (ListSecretVersionIdsRequest)((Object)obj);
        return Objects.equals(this.secretId(), other.secretId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.includeDeprecated(), other.includeDeprecated());
    }

    public String toString() {
        return ToString.builder((String)"ListSecretVersionIdsRequest").add("SecretId", (Object)this.secretId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("IncludeDeprecated", (Object)this.includeDeprecated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretId": {
                return Optional.ofNullable(clazz.cast(this.secretId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IncludeDeprecated": {
                return Optional.ofNullable(clazz.cast(this.includeDeprecated()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private String secretId;
        private Integer maxResults;
        private String nextToken;
        private Boolean includeDeprecated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretVersionIdsRequest model) {
            super(model);
            this.secretId(model.secretId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.includeDeprecated(model.includeDeprecated);
        }

        public final String getSecretId() {
            return this.secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getIncludeDeprecated() {
            return this.includeDeprecated;
        }

        @Override
        public final Builder includeDeprecated(Boolean includeDeprecated) {
            this.includeDeprecated = includeDeprecated;
            return this;
        }

        public final void setIncludeDeprecated(Boolean includeDeprecated) {
            this.includeDeprecated = includeDeprecated;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSecretVersionIdsRequest build() {
            return new ListSecretVersionIdsRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, ListSecretVersionIdsRequest> {
        public Builder secretId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder includeDeprecated(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

