/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import java.nio.ByteBuffer;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateSecretRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> SECRETBINARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretBinary").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretString").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateSecretRequestModelMarshaller INSTANCE = new CreateSecretRequestModelMarshaller();

    private CreateSecretRequestModelMarshaller() {
    }

    public static CreateSecretRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateSecretRequest createSecretRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createSecretRequest), (String)"createSecretRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createSecretRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createSecretRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createSecretRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createSecretRequest.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)createSecretRequest.secretBinary(), SECRETBINARY_BINDING);
            protocolMarshaller.marshall((Object)createSecretRequest.secretString(), SECRETSTRING_BINDING);
            protocolMarshaller.marshall(createSecretRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

