/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSecretValueRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, GetSecretValueRequest> {
    private final String secretId;
    private final String versionId;
    private final String versionStage;

    private GetSecretValueRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.versionId = builder.versionId;
        this.versionStage = builder.versionStage;
    }

    public String secretId() {
        return this.secretId;
    }

    public String versionId() {
        return this.versionId;
    }

    public String versionStage() {
        return this.versionStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecretValueRequest)) {
            return false;
        }
        GetSecretValueRequest other = (GetSecretValueRequest)((Object)obj);
        return Objects.equals(this.secretId(), other.secretId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.versionStage(), other.versionStage());
    }

    public String toString() {
        return ToString.builder((String)"GetSecretValueRequest").add("SecretId", (Object)this.secretId()).add("VersionId", (Object)this.versionId()).add("VersionStage", (Object)this.versionStage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretId": {
                return Optional.of(clazz.cast(this.secretId()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "VersionStage": {
                return Optional.of(clazz.cast(this.versionStage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private String secretId;
        private String versionId;
        private String versionStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecretValueRequest model) {
            super(model);
            this.secretId(model.secretId);
            this.versionId(model.versionId);
            this.versionStage(model.versionStage);
        }

        public final String getSecretId() {
            return this.secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getVersionStage() {
            return this.versionStage;
        }

        @Override
        public final Builder versionStage(String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        public final void setVersionStage(String versionStage) {
            this.versionStage = versionStage;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetSecretValueRequest build() {
            return new GetSecretValueRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, GetSecretValueRequest> {
        public Builder secretId(String var1);

        public Builder versionId(String var1);

        public Builder versionStage(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

