/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchedulesRequest extends SchedulerRequest implements
        ToCopyableBuilder<ListSchedulesRequest.Builder, ListSchedulesRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(ListSchedulesRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ScheduleGroup").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSchedulesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(ListSchedulesRequest::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NamePrefix").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchedulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListSchedulesRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            MAX_RESULTS_FIELD, NAME_PREFIX_FIELD, NEXT_TOKEN_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupName;

    private final Integer maxResults;

    private final String namePrefix;

    private final String nextToken;

    private final String state;

    private ListSchedulesRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.maxResults = builder.maxResults;
        this.namePrefix = builder.namePrefix;
        this.nextToken = builder.nextToken;
        this.state = builder.state;
    }

    /**
     * <p>
     * If specified, only lists the schedules whose associated schedule group matches the given filter.
     * </p>
     * 
     * @return If specified, only lists the schedules whose associated schedule group matches the given filter.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * If specified, limits the number of results returned by this operation. The operation also returns a
     * <code>NextToken</code> which you can use in a subsequent operation to retrieve the next set of results.
     * </p>
     * 
     * @return If specified, limits the number of results returned by this operation. The operation also returns a
     *         <code>NextToken</code> which you can use in a subsequent operation to retrieve the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Schedule name prefix to return the filtered list of resources.
     * </p>
     * 
     * @return Schedule name prefix to return the filtered list of resources.
     */
    public final String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * The token returned by a previous call to retrieve the next set of results.
     * </p>
     * 
     * @return The token returned by a previous call to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * If specified, only lists the schedules whose current state matches the given filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return If specified, only lists the schedules whose current state matches the given filter.
     * @see ScheduleState
     */
    public final ScheduleState state() {
        return ScheduleState.fromValue(state);
    }

    /**
     * <p>
     * If specified, only lists the schedules whose current state matches the given filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return If specified, only lists the schedules whose current state matches the given filter.
     * @see ScheduleState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchedulesRequest)) {
            return false;
        }
        ListSchedulesRequest other = (ListSchedulesRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(namePrefix(), other.namePrefix()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchedulesRequest").add("GroupName", groupName()).add("MaxResults", maxResults())
                .add("NamePrefix", namePrefix()).add("NextToken", nextToken()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduleGroup", GROUP_NAME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchedulesRequest, T> g) {
        return obj -> g.apply((ListSchedulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SchedulerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSchedulesRequest> {
        /**
         * <p>
         * If specified, only lists the schedules whose associated schedule group matches the given filter.
         * </p>
         * 
         * @param groupName
         *        If specified, only lists the schedules whose associated schedule group matches the given filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * If specified, limits the number of results returned by this operation. The operation also returns a
         * <code>NextToken</code> which you can use in a subsequent operation to retrieve the next set of results.
         * </p>
         * 
         * @param maxResults
         *        If specified, limits the number of results returned by this operation. The operation also returns a
         *        <code>NextToken</code> which you can use in a subsequent operation to retrieve the next set of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Schedule name prefix to return the filtered list of resources.
         * </p>
         * 
         * @param namePrefix
         *        Schedule name prefix to return the filtered list of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * The token returned by a previous call to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * If specified, only lists the schedules whose current state matches the given filter.
         * </p>
         * 
         * @param state
         *        If specified, only lists the schedules whose current state matches the given filter.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder state(String state);

        /**
         * <p>
         * If specified, only lists the schedules whose current state matches the given filter.
         * </p>
         * 
         * @param state
         *        If specified, only lists the schedules whose current state matches the given filter.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder state(ScheduleState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchedulerRequest.BuilderImpl implements Builder {
        private String groupName;

        private Integer maxResults;

        private String namePrefix;

        private String nextToken;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchedulesRequest model) {
            super(model);
            groupName(model.groupName);
            maxResults(model.maxResults);
            namePrefix(model.namePrefix);
            nextToken(model.nextToken);
            state(model.state);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchedulesRequest build() {
            return new ListSchedulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
