/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupResponse;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupResponse;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest;
import software.amazon.awssdk.services.scheduler.model.GetScheduleGroupResponse;
import software.amazon.awssdk.services.scheduler.model.GetScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.GetScheduleResponse;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse;
import software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.scheduler.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.scheduler.model.TagResourceRequest;
import software.amazon.awssdk.services.scheduler.model.TagResourceResponse;
import software.amazon.awssdk.services.scheduler.model.UntagResourceRequest;
import software.amazon.awssdk.services.scheduler.model.UntagResourceResponse;
import software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest;
import software.amazon.awssdk.services.scheduler.model.UpdateScheduleResponse;
import software.amazon.awssdk.services.scheduler.paginators.ListScheduleGroupsPublisher;
import software.amazon.awssdk.services.scheduler.paginators.ListSchedulesPublisher;

/**
 * Service client for accessing Amazon EventBridge Scheduler asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon EventBridge Scheduler is a serverless scheduler that allows you to create, run, and manage tasks from one
 * central, managed service. EventBridge Scheduler delivers your tasks reliably, with built-in mechanisms that adjust
 * your schedules based on the availability of downstream targets. The following reference lists the available API
 * actions, and data types for EventBridge Scheduler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SchedulerAsyncClient extends AwsClient {
    String SERVICE_NAME = "scheduler";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "scheduler";

    /**
     * <p>
     * Creates the specified schedule.
     * </p>
     *
     * @param createScheduleRequest
     * @return A Java Future containing the result of the CreateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.CreateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateScheduleResponse> createSchedule(CreateScheduleRequest createScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScheduleRequest#builder()}
     * </p>
     *
     * @param createScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.CreateScheduleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.CreateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateScheduleResponse> createSchedule(Consumer<CreateScheduleRequest.Builder> createScheduleRequest) {
        return createSchedule(CreateScheduleRequest.builder().applyMutation(createScheduleRequest).build());
    }

    /**
     * <p>
     * Creates the specified schedule group.
     * </p>
     *
     * @param createScheduleGroupRequest
     * @return A Java Future containing the result of the CreateScheduleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.CreateScheduleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateScheduleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateScheduleGroupResponse> createScheduleGroup(
            CreateScheduleGroupRequest createScheduleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified schedule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduleGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateScheduleGroupRequest#builder()}
     * </p>
     *
     * @param createScheduleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateScheduleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.CreateScheduleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateScheduleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateScheduleGroupResponse> createScheduleGroup(
            Consumer<CreateScheduleGroupRequest.Builder> createScheduleGroupRequest) {
        return createScheduleGroup(CreateScheduleGroupRequest.builder().applyMutation(createScheduleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified schedule.
     * </p>
     *
     * @param deleteScheduleRequest
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScheduleRequest#builder()}
     * </p>
     *
     * @param deleteScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.DeleteScheduleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScheduleResponse> deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest) {
        return deleteSchedule(DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all
     * schedules associated with the group. When you delete a group, it remains in a <code>DELETING</code> state until
     * all of its associated schedules are deleted. Schedules associated with the group that are set to run while the
     * schedule group is in the process of being deleted might continue to invoke their targets until the schedule group
     * and its associated schedules are deleted.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent.
     * </p>
     * </note>
     *
     * @param deleteScheduleGroupRequest
     * @return A Java Future containing the result of the DeleteScheduleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.DeleteScheduleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteScheduleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteScheduleGroupResponse> deleteScheduleGroup(
            DeleteScheduleGroupRequest deleteScheduleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all
     * schedules associated with the group. When you delete a group, it remains in a <code>DELETING</code> state until
     * all of its associated schedules are deleted. Schedules associated with the group that are set to run while the
     * schedule group is in the process of being deleted might continue to invoke their targets until the schedule group
     * and its associated schedules are deleted.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduleGroupRequest#builder()}
     * </p>
     *
     * @param deleteScheduleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScheduleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.DeleteScheduleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteScheduleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteScheduleGroupResponse> deleteScheduleGroup(
            Consumer<DeleteScheduleGroupRequest.Builder> deleteScheduleGroupRequest) {
        return deleteScheduleGroup(DeleteScheduleGroupRequest.builder().applyMutation(deleteScheduleGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified schedule.
     * </p>
     *
     * @param getScheduleRequest
     * @return A Java Future containing the result of the GetSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.GetSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetScheduleResponse> getSchedule(GetScheduleRequest getScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link GetScheduleRequest#builder()}
     * </p>
     *
     * @param getScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.GetScheduleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.GetSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetScheduleResponse> getSchedule(Consumer<GetScheduleRequest.Builder> getScheduleRequest) {
        return getSchedule(GetScheduleRequest.builder().applyMutation(getScheduleRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified schedule group.
     * </p>
     *
     * @param getScheduleGroupRequest
     * @return A Java Future containing the result of the GetScheduleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.GetScheduleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetScheduleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetScheduleGroupResponse> getScheduleGroup(GetScheduleGroupRequest getScheduleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified schedule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScheduleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetScheduleGroupRequest#builder()}
     * </p>
     *
     * @param getScheduleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.GetScheduleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetScheduleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.GetScheduleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetScheduleGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetScheduleGroupResponse> getScheduleGroup(
            Consumer<GetScheduleGroupRequest.Builder> getScheduleGroupRequest) {
        return getScheduleGroup(GetScheduleGroupRequest.builder().applyMutation(getScheduleGroupRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of your schedule groups.
     * </p>
     *
     * @param listScheduleGroupsRequest
     * @return A Java Future containing the result of the ListScheduleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListScheduleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListScheduleGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListScheduleGroupsResponse> listScheduleGroups(ListScheduleGroupsRequest listScheduleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of your schedule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduleGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduleGroupsRequest#builder()}
     * </p>
     *
     * @param listScheduleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListScheduleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListScheduleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListScheduleGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListScheduleGroupsResponse> listScheduleGroups(
            Consumer<ListScheduleGroupsRequest.Builder> listScheduleGroupsRequest) {
        return listScheduleGroups(ListScheduleGroupsRequest.builder().applyMutation(listScheduleGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScheduleGroups(software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListScheduleGroupsPublisher publisher = client.listScheduleGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListScheduleGroupsPublisher publisher = client.listScheduleGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScheduleGroups(software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listScheduleGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListScheduleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListScheduleGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScheduleGroupsPublisher listScheduleGroupsPaginator(ListScheduleGroupsRequest listScheduleGroupsRequest) {
        return new ListScheduleGroupsPublisher(this, listScheduleGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScheduleGroups(software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListScheduleGroupsPublisher publisher = client.listScheduleGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListScheduleGroupsPublisher publisher = client.listScheduleGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScheduleGroups(software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduleGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduleGroupsRequest#builder()}
     * </p>
     *
     * @param listScheduleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListScheduleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListScheduleGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScheduleGroupsPublisher listScheduleGroupsPaginator(
            Consumer<ListScheduleGroupsRequest.Builder> listScheduleGroupsRequest) {
        return listScheduleGroupsPaginator(ListScheduleGroupsRequest.builder().applyMutation(listScheduleGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of your EventBridge Scheduler schedules.
     * </p>
     *
     * @param listSchedulesRequest
     * @return A Java Future containing the result of the ListSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchedulesResponse> listSchedules(ListSchedulesRequest listSchedulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of your EventBridge Scheduler schedules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchedulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchedulesRequest#builder()}
     * </p>
     *
     * @param listSchedulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchedulesResponse> listSchedules(Consumer<ListSchedulesRequest.Builder> listSchedulesRequest) {
        return listSchedules(ListSchedulesRequest.builder().applyMutation(listSchedulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSchedules(software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListSchedulesPublisher publisher = client.listSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListSchedulesPublisher publisher = client.listSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchedules(software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest)} operation.</b>
     * </p>
     *
     * @param listSchedulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchedulesPublisher listSchedulesPaginator(ListSchedulesRequest listSchedulesRequest) {
        return new ListSchedulesPublisher(this, listSchedulesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSchedules(software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListSchedulesPublisher publisher = client.listSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.scheduler.paginators.ListSchedulesPublisher publisher = client.listSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchedules(software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchedulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchedulesRequest#builder()}
     * </p>
     *
     * @param listSchedulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListSchedules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchedulesPublisher listSchedulesPaginator(Consumer<ListSchedulesRequest.Builder> listSchedulesRequest) {
        return listSchedulesPaginator(ListSchedulesRequest.builder().applyMutation(listSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with the Scheduler resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with the Scheduler resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource. You can only assign
     * tags to schedule groups.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource. You can only assign
     * tags to schedule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified EventBridge Scheduler schedule group.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified EventBridge Scheduler schedule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified schedule. When you call <code>UpdateSchedule</code>, EventBridge Scheduler uses all values,
     * including empty values, specified in the request and overrides the existing schedule. This is by design. This
     * means that if you do not set an optional field in your request, that field will be set to its system-default
     * value after the update.
     * </p>
     * <p>
     * Before calling this operation, we recommend that you call the <code>GetSchedule</code> API operation and make a
     * note of all optional parameters for your <code>UpdateSchedule</code> call.
     * </p>
     *
     * @param updateScheduleRequest
     * @return A Java Future containing the result of the UpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.UpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UpdateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateScheduleResponse> updateSchedule(UpdateScheduleRequest updateScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified schedule. When you call <code>UpdateSchedule</code>, EventBridge Scheduler uses all values,
     * including empty values, specified in the request and overrides the existing schedule. This is by design. This
     * means that if you do not set an optional field in your request, that field will be set to its system-default
     * value after the update.
     * </p>
     * <p>
     * Before calling this operation, we recommend that you call the <code>GetSchedule</code> API operation and make a
     * note of all optional parameters for your <code>UpdateSchedule</code> call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateScheduleRequest#builder()}
     * </p>
     *
     * @param updateScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>InternalServerException Unexpected error encountered while processing the request.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException The request references a resource which does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchedulerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchedulerAsyncClient.UpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UpdateSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateScheduleResponse> updateSchedule(Consumer<UpdateScheduleRequest.Builder> updateScheduleRequest) {
        return updateSchedule(UpdateScheduleRequest.builder().applyMutation(updateScheduleRequest).build());
    }

    @Override
    default SchedulerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SchedulerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SchedulerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SchedulerAsyncClient}.
     */
    static SchedulerAsyncClientBuilder builder() {
        return new DefaultSchedulerAsyncClientBuilder();
    }
}
