/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.scheduler.model.ScheduleState;
import software.amazon.awssdk.services.scheduler.model.TargetSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ScheduleSummary.getter(ScheduleSummary::arn)).setter(ScheduleSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(ScheduleSummary.getter(ScheduleSummary::creationDate)).setter(ScheduleSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(ScheduleSummary.getter(ScheduleSummary::groupName)).setter(ScheduleSummary.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationDate").getter(ScheduleSummary.getter(ScheduleSummary::lastModificationDate)).setter(ScheduleSummary.setter(Builder::lastModificationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ScheduleSummary.getter(ScheduleSummary::name)).setter(ScheduleSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ScheduleSummary.getter(ScheduleSummary::stateAsString)).setter(ScheduleSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<TargetSummary> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Target").getter(ScheduleSummary.getter(ScheduleSummary::target)).setter(ScheduleSummary.setter(Builder::target)).constructor(TargetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_DATE_FIELD, GROUP_NAME_FIELD, LAST_MODIFICATION_DATE_FIELD, NAME_FIELD, STATE_FIELD, TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("LastModificationDate", LAST_MODIFICATION_DATE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("State", STATE_FIELD);
            this.put("Target", TARGET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant creationDate;
    private final String groupName;
    private final Instant lastModificationDate;
    private final String name;
    private final String state;
    private final TargetSummary target;

    private ScheduleSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.groupName = builder.groupName;
        this.lastModificationDate = builder.lastModificationDate;
        this.name = builder.name;
        this.state = builder.state;
        this.target = builder.target;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final Instant lastModificationDate() {
        return this.lastModificationDate;
    }

    public final String name() {
        return this.name;
    }

    public final ScheduleState state() {
        return ScheduleState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final TargetSummary target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleSummary)) {
            return false;
        }
        ScheduleSummary other = (ScheduleSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.lastModificationDate(), other.lastModificationDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleSummary").add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("GroupName", (Object)this.groupName()).add("LastModificationDate", (Object)this.lastModificationDate()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "LastModificationDate": {
                return Optional.ofNullable(clazz.cast(this.lastModificationDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleSummary, T> g) {
        return obj -> g.apply((ScheduleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationDate;
        private String groupName;
        private Instant lastModificationDate;
        private String name;
        private String state;
        private TargetSummary target;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleSummary model) {
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.groupName(model.groupName);
            this.lastModificationDate(model.lastModificationDate);
            this.name(model.name);
            this.state(model.state);
            this.target(model.target);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Instant getLastModificationDate() {
            return this.lastModificationDate;
        }

        public final void setLastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
        }

        @Override
        public final Builder lastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final TargetSummary.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(TargetSummary.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TargetSummary target) {
            this.target = target;
            return this;
        }

        public ScheduleSummary build() {
            return new ScheduleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleSummary> {
        public Builder arn(String var1);

        public Builder creationDate(Instant var1);

        public Builder groupName(String var1);

        public Builder lastModificationDate(Instant var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(ScheduleState var1);

        public Builder target(TargetSummary var1);

        default public Builder target(Consumer<TargetSummary.Builder> target) {
            return this.target((TargetSummary)((TargetSummary.Builder)TargetSummary.builder().applyMutation(target)).build());
        }
    }
}

