/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScheduleResponse extends SchedulerResponse implements
        ToCopyableBuilder<GetScheduleResponse.Builder, GetScheduleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetScheduleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GetScheduleResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetScheduleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(GetScheduleResponse::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<FlexibleTimeWindow> FLEXIBLE_TIME_WINDOW_FIELD = SdkField
            .<FlexibleTimeWindow> builder(MarshallingType.SDK_POJO).memberName("FlexibleTimeWindow")
            .getter(getter(GetScheduleResponse::flexibleTimeWindow)).setter(setter(Builder::flexibleTimeWindow))
            .constructor(FlexibleTimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexibleTimeWindow").build())
            .build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(GetScheduleResponse::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(GetScheduleResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationDate").getter(getter(GetScheduleResponse::lastModificationDate))
            .setter(setter(Builder::lastModificationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationDate").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetScheduleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(GetScheduleResponse::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpressionTimezone")
            .getter(getter(GetScheduleResponse::scheduleExpressionTimezone))
            .setter(setter(Builder::scheduleExpressionTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build())
            .build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(GetScheduleResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetScheduleResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(GetScheduleResponse::target)).setter(setter(Builder::target)).constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_FIELD, DESCRIPTION_FIELD, END_DATE_FIELD, FLEXIBLE_TIME_WINDOW_FIELD, GROUP_NAME_FIELD,
            KMS_KEY_ARN_FIELD, LAST_MODIFICATION_DATE_FIELD, NAME_FIELD, SCHEDULE_EXPRESSION_FIELD,
            SCHEDULE_EXPRESSION_TIMEZONE_FIELD, START_DATE_FIELD, STATE_FIELD, TARGET_FIELD));

    private final String arn;

    private final Instant creationDate;

    private final String description;

    private final Instant endDate;

    private final FlexibleTimeWindow flexibleTimeWindow;

    private final String groupName;

    private final String kmsKeyArn;

    private final Instant lastModificationDate;

    private final String name;

    private final String scheduleExpression;

    private final String scheduleExpressionTimezone;

    private final Instant startDate;

    private final String state;

    private final Target target;

    private GetScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.endDate = builder.endDate;
        this.flexibleTimeWindow = builder.flexibleTimeWindow;
        this.groupName = builder.groupName;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastModificationDate = builder.lastModificationDate;
        this.name = builder.name;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startDate = builder.startDate;
        this.state = builder.state;
        this.target = builder.target;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schedule.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the schedule was created.
     * </p>
     * 
     * @return The time at which the schedule was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The description of the schedule.
     * </p>
     * 
     * @return The description of the schedule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence
     * expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler
     * ignores <code>EndDate</code> for one-time schedules.
     * </p>
     * 
     * @return The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence
     *         expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge
     *         Scheduler ignores <code>EndDate</code> for one-time schedules.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     * </p>
     * 
     * @return Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     */
    public final FlexibleTimeWindow flexibleTimeWindow() {
        return flexibleTimeWindow;
    }

    /**
     * <p>
     * The name of the schedule group associated with this schedule.
     * </p>
     * 
     * @return The name of the schedule group associated with this schedule.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.
     * </p>
     * 
     * @return The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The time at which the schedule was last modified.
     * </p>
     * 
     * @return The time at which the schedule was last modified.
     */
    public final Instant lastModificationDate() {
        return lastModificationDate;
    }

    /**
     * <p>
     * The name of the schedule.
     * </p>
     * 
     * @return The name of the schedule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The expression that defines when the schedule runs. The following formats are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rate</code> expression - <code>rate(unit value)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cron</code> expression - <code>cron(fields)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and
     * in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create
     * recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such
     * as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target
     * periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
     * </p>
     * <p>
     * A <code>cron</code> expression consists of six fields separated by white spaces:
     * <code>(minutes hours day_of_month month day_of_week year)</code>.
     * </p>
     * <p>
     * A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the
     * following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> |
     * <code>day</code> | <code>days</code>
     * </p>
     * <p>
     * For more information and examples, see <a
     * href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge
     * Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
     * </p>
     * 
     * @return The expression that defines when the schedule runs. The following formats are supported. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rate</code> expression - <code>rate(unit value)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cron</code> expression - <code>cron(fields)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the
     *         time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code>
     *         expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a
     *         target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful
     *         when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st
     *         day of the month.
     *         </p>
     *         <p>
     *         A <code>cron</code> expression consists of six fields separated by white spaces:
     *         <code>(minutes hours day_of_month month day_of_week year)</code>.
     *         </p>
     *         <p>
     *         A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with
     *         the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> |
     *         <code>hours</code> | <code>day</code> | <code>days</code>
     *         </p>
     *         <p>
     *         For more information and examples, see <a
     *         href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on
     *         EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The timezone in which the scheduling expression is evaluated.
     * </p>
     * 
     * @return The timezone in which the scheduling expression is evaluated.
     */
    public final String scheduleExpressionTimezone() {
        return scheduleExpressionTimezone;
    }

    /**
     * <p>
     * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence
     * expression, invocations might occur on, or after, the <code>StartDate</code> you specify. EventBridge Scheduler
     * ignores <code>StartDate</code> for one-time schedules.
     * </p>
     * 
     * @return The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's
     *         recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
     *         EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * Specifies whether the schedule is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the schedule is enabled or disabled.
     * @see ScheduleState
     */
    public final ScheduleState state() {
        return ScheduleState.fromValue(state);
    }

    /**
     * <p>
     * Specifies whether the schedule is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the schedule is enabled or disabled.
     * @see ScheduleState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The schedule target.
     * </p>
     * 
     * @return The schedule target.
     */
    public final Target target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(flexibleTimeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduleResponse)) {
            return false;
        }
        GetScheduleResponse other = (GetScheduleResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(description(), other.description()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(flexibleTimeWindow(), other.flexibleTimeWindow())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(lastModificationDate(), other.lastModificationDate()) && Objects.equals(name(), other.name())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(scheduleExpressionTimezone(), other.scheduleExpressionTimezone())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScheduleResponse").add("Arn", arn()).add("CreationDate", creationDate())
                .add("Description", description()).add("EndDate", endDate()).add("FlexibleTimeWindow", flexibleTimeWindow())
                .add("GroupName", groupName()).add("KmsKeyArn", kmsKeyArn()).add("LastModificationDate", lastModificationDate())
                .add("Name", name()).add("ScheduleExpression", scheduleExpression())
                .add("ScheduleExpressionTimezone", scheduleExpressionTimezone()).add("StartDate", startDate())
                .add("State", stateAsString()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "FlexibleTimeWindow":
            return Optional.ofNullable(clazz.cast(flexibleTimeWindow()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "LastModificationDate":
            return Optional.ofNullable(clazz.cast(lastModificationDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "ScheduleExpressionTimezone":
            return Optional.ofNullable(clazz.cast(scheduleExpressionTimezone()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScheduleResponse, T> g) {
        return obj -> g.apply((GetScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchedulerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetScheduleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schedule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the schedule was created.
         * </p>
         * 
         * @param creationDate
         *        The time at which the schedule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The description of the schedule.
         * </p>
         * 
         * @param description
         *        The description of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence
         * expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler
         * ignores <code>EndDate</code> for one-time schedules.
         * </p>
         * 
         * @param endDate
         *        The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's
         *        recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify.
         *        EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         * </p>
         * 
         * @param flexibleTimeWindow
         *        Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flexibleTimeWindow(FlexibleTimeWindow flexibleTimeWindow);

        /**
         * <p>
         * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlexibleTimeWindow.Builder} avoiding the
         * need to create one manually via {@link FlexibleTimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlexibleTimeWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #flexibleTimeWindow(FlexibleTimeWindow)}.
         * 
         * @param flexibleTimeWindow
         *        a consumer that will call methods on {@link FlexibleTimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flexibleTimeWindow(FlexibleTimeWindow)
         */
        default Builder flexibleTimeWindow(Consumer<FlexibleTimeWindow.Builder> flexibleTimeWindow) {
            return flexibleTimeWindow(FlexibleTimeWindow.builder().applyMutation(flexibleTimeWindow).build());
        }

        /**
         * <p>
         * The name of the schedule group associated with this schedule.
         * </p>
         * 
         * @param groupName
         *        The name of the schedule group associated with this schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The time at which the schedule was last modified.
         * </p>
         * 
         * @param lastModificationDate
         *        The time at which the schedule was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationDate(Instant lastModificationDate);

        /**
         * <p>
         * The name of the schedule.
         * </p>
         * 
         * @param name
         *        The name of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The expression that defines when the schedule runs. The following formats are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rate</code> expression - <code>rate(unit value)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cron</code> expression - <code>cron(fields)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time
         * and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to
         * create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular
         * intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to
         * invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
         * </p>
         * <p>
         * A <code>cron</code> expression consists of six fields separated by white spaces:
         * <code>(minutes hours day_of_month month day_of_week year)</code>.
         * </p>
         * <p>
         * A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the
         * following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> |
         * <code>day</code> | <code>days</code>
         * </p>
         * <p>
         * For more information and examples, see <a
         * href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on
         * EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
         * </p>
         * 
         * @param scheduleExpression
         *        The expression that defines when the schedule runs. The following formats are supported. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rate</code> expression - <code>rate(unit value)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cron</code> expression - <code>cron(fields)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the
         *        time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code>
         *        expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a
         *        target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are
         *        useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0)
         *        every 1st day of the month.
         *        </p>
         *        <p>
         *        A <code>cron</code> expression consists of six fields separated by white spaces:
         *        <code>(minutes hours day_of_month month day_of_week year)</code>.
         *        </p>
         *        <p>
         *        A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i>
         *        with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> |
         *        <code>hours</code> | <code>day</code> | <code>days</code>
         *        </p>
         *        <p>
         *        For more information and examples, see <a
         *        href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on
         *        EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The timezone in which the scheduling expression is evaluated.
         * </p>
         * 
         * @param scheduleExpressionTimezone
         *        The timezone in which the scheduling expression is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpressionTimezone(String scheduleExpressionTimezone);

        /**
         * <p>
         * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's
         * recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
         * EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
         * </p>
         * 
         * @param startDate
         *        The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's
         *        recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
         *        EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * Specifies whether the schedule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Specifies whether the schedule is enabled or disabled.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies whether the schedule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Specifies whether the schedule is enabled or disabled.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder state(ScheduleState state);

        /**
         * <p>
         * The schedule target.
         * </p>
         * 
         * @param target
         *        The schedule target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The schedule target.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }
    }

    static final class BuilderImpl extends SchedulerResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationDate;

        private String description;

        private Instant endDate;

        private FlexibleTimeWindow flexibleTimeWindow;

        private String groupName;

        private String kmsKeyArn;

        private Instant lastModificationDate;

        private String name;

        private String scheduleExpression;

        private String scheduleExpressionTimezone;

        private Instant startDate;

        private String state;

        private Target target;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduleResponse model) {
            super(model);
            arn(model.arn);
            creationDate(model.creationDate);
            description(model.description);
            endDate(model.endDate);
            flexibleTimeWindow(model.flexibleTimeWindow);
            groupName(model.groupName);
            kmsKeyArn(model.kmsKeyArn);
            lastModificationDate(model.lastModificationDate);
            name(model.name);
            scheduleExpression(model.scheduleExpression);
            scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            startDate(model.startDate);
            state(model.state);
            target(model.target);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final FlexibleTimeWindow.Builder getFlexibleTimeWindow() {
            return flexibleTimeWindow != null ? flexibleTimeWindow.toBuilder() : null;
        }

        public final void setFlexibleTimeWindow(FlexibleTimeWindow.BuilderImpl flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow != null ? flexibleTimeWindow.build() : null;
        }

        @Override
        public final Builder flexibleTimeWindow(FlexibleTimeWindow flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getLastModificationDate() {
            return lastModificationDate;
        }

        public final void setLastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
        }

        @Override
        public final Builder lastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        @Override
        public GetScheduleResponse build() {
            return new GetScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
