/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.scheduler.SchedulerClient;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse;
import software.amazon.awssdk.services.scheduler.model.ScheduleSummary;

public class ListSchedulesIterable
implements SdkIterable<ListSchedulesResponse> {
    private final SchedulerClient client;
    private final ListSchedulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSchedulesIterable(SchedulerClient client, ListSchedulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSchedulesResponseFetcher();
    }

    public Iterator<ListSchedulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduleSummary> schedules() {
        Function<ListSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.schedules() != null) {
                return response.schedules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSchedulesResponseFetcher
    implements SyncPageFetcher<ListSchedulesResponse> {
        private ListSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSchedulesResponse nextPage(ListSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListSchedulesIterable.this.client.listSchedules(ListSchedulesIterable.this.firstRequest);
            }
            return ListSchedulesIterable.this.client.listSchedules((ListSchedulesRequest)((Object)ListSchedulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

