/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Savings Plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlan implements SdkPojo, Serializable, ToCopyableBuilder<SavingsPlan.Builder, SavingsPlan> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(SavingsPlan::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanId").getter(getter(SavingsPlan::savingsPlanId)).setter(setter(Builder::savingsPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()).build();

    private static final SdkField<String> SAVINGS_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanArn").getter(getter(SavingsPlan::savingsPlanArn)).setter(setter(Builder::savingsPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SavingsPlan::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("start")
            .getter(getter(SavingsPlan::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("end")
            .getter(getter(SavingsPlan::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(SavingsPlan::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(SavingsPlan::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> EC2_INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceFamily").getter(getter(SavingsPlan::ec2InstanceFamily))
            .setter(setter(Builder::ec2InstanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceFamily").build()).build();

    private static final SdkField<String> SAVINGS_PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanType").getter(getter(SavingsPlan::savingsPlanTypeAsString))
            .setter(setter(Builder::savingsPlanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanType").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(SavingsPlan::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<List<String>> PRODUCT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("productTypes")
            .getter(getter(SavingsPlan::productTypesAsStrings))
            .setter(setter(Builder::productTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(SavingsPlan::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitment").getter(getter(SavingsPlan::commitment)).setter(setter(Builder::commitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()).build();

    private static final SdkField<String> UPFRONT_PAYMENT_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upfrontPaymentAmount").getter(getter(SavingsPlan::upfrontPaymentAmount))
            .setter(setter(Builder::upfrontPaymentAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontPaymentAmount").build())
            .build();

    private static final SdkField<String> RECURRING_PAYMENT_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recurringPaymentAmount").getter(getter(SavingsPlan::recurringPaymentAmount))
            .setter(setter(Builder::recurringPaymentAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recurringPaymentAmount").build())
            .build();

    private static final SdkField<Long> TERM_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("termDurationInSeconds").getter(getter(SavingsPlan::termDurationInSeconds))
            .setter(setter(Builder::termDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termDurationInSeconds").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SavingsPlan::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RETURNABLE_UNTIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("returnableUntil").getter(getter(SavingsPlan::returnableUntil)).setter(setter(Builder::returnableUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnableUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD,
            SAVINGS_PLAN_ID_FIELD, SAVINGS_PLAN_ARN_FIELD, DESCRIPTION_FIELD, START_FIELD, END_FIELD, STATE_FIELD, REGION_FIELD,
            EC2_INSTANCE_FAMILY_FIELD, SAVINGS_PLAN_TYPE_FIELD, PAYMENT_OPTION_FIELD, PRODUCT_TYPES_FIELD, CURRENCY_FIELD,
            COMMITMENT_FIELD, UPFRONT_PAYMENT_AMOUNT_FIELD, RECURRING_PAYMENT_AMOUNT_FIELD, TERM_DURATION_IN_SECONDS_FIELD,
            TAGS_FIELD, RETURNABLE_UNTIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String offeringId;

    private final String savingsPlanId;

    private final String savingsPlanArn;

    private final String description;

    private final String start;

    private final String end;

    private final String state;

    private final String region;

    private final String ec2InstanceFamily;

    private final String savingsPlanType;

    private final String paymentOption;

    private final List<String> productTypes;

    private final String currency;

    private final String commitment;

    private final String upfrontPaymentAmount;

    private final String recurringPaymentAmount;

    private final Long termDurationInSeconds;

    private final Map<String, String> tags;

    private final String returnableUntil;

    private SavingsPlan(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.savingsPlanId = builder.savingsPlanId;
        this.savingsPlanArn = builder.savingsPlanArn;
        this.description = builder.description;
        this.start = builder.start;
        this.end = builder.end;
        this.state = builder.state;
        this.region = builder.region;
        this.ec2InstanceFamily = builder.ec2InstanceFamily;
        this.savingsPlanType = builder.savingsPlanType;
        this.paymentOption = builder.paymentOption;
        this.productTypes = builder.productTypes;
        this.currency = builder.currency;
        this.commitment = builder.commitment;
        this.upfrontPaymentAmount = builder.upfrontPaymentAmount;
        this.recurringPaymentAmount = builder.recurringPaymentAmount;
        this.termDurationInSeconds = builder.termDurationInSeconds;
        this.tags = builder.tags;
        this.returnableUntil = builder.returnableUntil;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The ID of the Savings Plan.
     * </p>
     * 
     * @return The ID of the Savings Plan.
     */
    public final String savingsPlanId() {
        return savingsPlanId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Savings Plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Savings Plan.
     */
    public final String savingsPlanArn() {
        return savingsPlanArn;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The start time.
     * </p>
     * 
     * @return The start time.
     */
    public final String start() {
        return start;
    }

    /**
     * <p>
     * The end time.
     * </p>
     * 
     * @return The end time.
     */
    public final String end() {
        return end;
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SavingsPlanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see SavingsPlanState
     */
    public final SavingsPlanState state() {
        return SavingsPlanState.fromValue(state);
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SavingsPlanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see SavingsPlanState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The EC2 instance family.
     * </p>
     * 
     * @return The EC2 instance family.
     */
    public final String ec2InstanceFamily() {
        return ec2InstanceFamily;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlanType}
     * will return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #savingsPlanTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final SavingsPlanType savingsPlanType() {
        return SavingsPlanType.fromValue(savingsPlanType);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlanType}
     * will return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #savingsPlanTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final String savingsPlanTypeAsString() {
        return savingsPlanType;
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The product types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductTypes} method.
     * </p>
     * 
     * @return The product types.
     */
    public final List<SavingsPlanProductType> productTypes() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(productTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductTypes() {
        return productTypes != null && !(productTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductTypes} method.
     * </p>
     * 
     * @return The product types.
     */
    public final List<String> productTypesAsStrings() {
        return productTypes;
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(currency);
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The hourly commitment amount in the specified currency.
     * </p>
     * 
     * @return The hourly commitment amount in the specified currency.
     */
    public final String commitment() {
        return commitment;
    }

    /**
     * <p>
     * The up-front payment amount.
     * </p>
     * 
     * @return The up-front payment amount.
     */
    public final String upfrontPaymentAmount() {
        return upfrontPaymentAmount;
    }

    /**
     * <p>
     * The recurring payment amount.
     * </p>
     * 
     * @return The recurring payment amount.
     */
    public final String recurringPaymentAmount() {
        return recurringPaymentAmount;
    }

    /**
     * <p>
     * The duration of the term, in seconds.
     * </p>
     * 
     * @return The duration of the term, in seconds.
     */
    public final Long termDurationInSeconds() {
        return termDurationInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The time until when a return for the Savings Plan can be requested. If the Savings Plan is not returnable, the
     * field reflects the Savings Plans start time.
     * </p>
     * 
     * @return The time until when a return for the Savings Plan can be requested. If the Savings Plan is not
     *         returnable, the field reflects the Savings Plans start time.
     */
    public final String returnableUntil() {
        return returnableUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductTypes() ? productTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commitment());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(recurringPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(termDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnableUntil());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlan)) {
            return false;
        }
        SavingsPlan other = (SavingsPlan) obj;
        return Objects.equals(offeringId(), other.offeringId()) && Objects.equals(savingsPlanId(), other.savingsPlanId())
                && Objects.equals(savingsPlanArn(), other.savingsPlanArn()) && Objects.equals(description(), other.description())
                && Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(region(), other.region())
                && Objects.equals(ec2InstanceFamily(), other.ec2InstanceFamily())
                && Objects.equals(savingsPlanTypeAsString(), other.savingsPlanTypeAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && hasProductTypes() == other.hasProductTypes()
                && Objects.equals(productTypesAsStrings(), other.productTypesAsStrings())
                && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(commitment(), other.commitment())
                && Objects.equals(upfrontPaymentAmount(), other.upfrontPaymentAmount())
                && Objects.equals(recurringPaymentAmount(), other.recurringPaymentAmount())
                && Objects.equals(termDurationInSeconds(), other.termDurationInSeconds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(returnableUntil(), other.returnableUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlan").add("OfferingId", offeringId()).add("SavingsPlanId", savingsPlanId())
                .add("SavingsPlanArn", savingsPlanArn()).add("Description", description()).add("Start", start())
                .add("End", end()).add("State", stateAsString()).add("Region", region())
                .add("Ec2InstanceFamily", ec2InstanceFamily()).add("SavingsPlanType", savingsPlanTypeAsString())
                .add("PaymentOption", paymentOptionAsString())
                .add("ProductTypes", hasProductTypes() ? productTypesAsStrings() : null).add("Currency", currencyAsString())
                .add("Commitment", commitment()).add("UpfrontPaymentAmount", upfrontPaymentAmount())
                .add("RecurringPaymentAmount", recurringPaymentAmount()).add("TermDurationInSeconds", termDurationInSeconds())
                .add("Tags", hasTags() ? tags() : null).add("ReturnableUntil", returnableUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "savingsPlanId":
            return Optional.ofNullable(clazz.cast(savingsPlanId()));
        case "savingsPlanArn":
            return Optional.ofNullable(clazz.cast(savingsPlanArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ec2InstanceFamily":
            return Optional.ofNullable(clazz.cast(ec2InstanceFamily()));
        case "savingsPlanType":
            return Optional.ofNullable(clazz.cast(savingsPlanTypeAsString()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "productTypes":
            return Optional.ofNullable(clazz.cast(productTypesAsStrings()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "commitment":
            return Optional.ofNullable(clazz.cast(commitment()));
        case "upfrontPaymentAmount":
            return Optional.ofNullable(clazz.cast(upfrontPaymentAmount()));
        case "recurringPaymentAmount":
            return Optional.ofNullable(clazz.cast(recurringPaymentAmount()));
        case "termDurationInSeconds":
            return Optional.ofNullable(clazz.cast(termDurationInSeconds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "returnableUntil":
            return Optional.ofNullable(clazz.cast(returnableUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("savingsPlanId", SAVINGS_PLAN_ID_FIELD);
        map.put("savingsPlanArn", SAVINGS_PLAN_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        map.put("state", STATE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("ec2InstanceFamily", EC2_INSTANCE_FAMILY_FIELD);
        map.put("savingsPlanType", SAVINGS_PLAN_TYPE_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        map.put("productTypes", PRODUCT_TYPES_FIELD);
        map.put("currency", CURRENCY_FIELD);
        map.put("commitment", COMMITMENT_FIELD);
        map.put("upfrontPaymentAmount", UPFRONT_PAYMENT_AMOUNT_FIELD);
        map.put("recurringPaymentAmount", RECURRING_PAYMENT_AMOUNT_FIELD);
        map.put("termDurationInSeconds", TERM_DURATION_IN_SECONDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("returnableUntil", RETURNABLE_UNTIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlan, T> g) {
        return obj -> g.apply((SavingsPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlan> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The ID of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanId
         *        The ID of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanId(String savingsPlanId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanArn
         *        The Amazon Resource Name (ARN) of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArn(String savingsPlanArn);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The start time.
         * </p>
         * 
         * @param start
         *        The start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * The end time.
         * </p>
         * 
         * @param end
         *        The end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see SavingsPlanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see SavingsPlanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanState
         */
        Builder state(SavingsPlanState state);

        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The EC2 instance family.
         * </p>
         * 
         * @param ec2InstanceFamily
         *        The EC2 instance family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceFamily(String ec2InstanceFamily);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param savingsPlanType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder savingsPlanType(String savingsPlanType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param savingsPlanType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder savingsPlanType(SavingsPlanType savingsPlanType);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(SavingsPlanPaymentOption paymentOption);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypesWithStrings(Collection<String> productTypes);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypesWithStrings(String... productTypes);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypes(Collection<SavingsPlanProductType> productTypes);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypes(SavingsPlanProductType... productTypes);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(CurrencyCode currency);

        /**
         * <p>
         * The hourly commitment amount in the specified currency.
         * </p>
         * 
         * @param commitment
         *        The hourly commitment amount in the specified currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitment(String commitment);

        /**
         * <p>
         * The up-front payment amount.
         * </p>
         * 
         * @param upfrontPaymentAmount
         *        The up-front payment amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPaymentAmount(String upfrontPaymentAmount);

        /**
         * <p>
         * The recurring payment amount.
         * </p>
         * 
         * @param recurringPaymentAmount
         *        The recurring payment amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringPaymentAmount(String recurringPaymentAmount);

        /**
         * <p>
         * The duration of the term, in seconds.
         * </p>
         * 
         * @param termDurationInSeconds
         *        The duration of the term, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termDurationInSeconds(Long termDurationInSeconds);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The time until when a return for the Savings Plan can be requested. If the Savings Plan is not returnable,
         * the field reflects the Savings Plans start time.
         * </p>
         * 
         * @param returnableUntil
         *        The time until when a return for the Savings Plan can be requested. If the Savings Plan is not
         *        returnable, the field reflects the Savings Plans start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnableUntil(String returnableUntil);
    }

    static final class BuilderImpl implements Builder {
        private String offeringId;

        private String savingsPlanId;

        private String savingsPlanArn;

        private String description;

        private String start;

        private String end;

        private String state;

        private String region;

        private String ec2InstanceFamily;

        private String savingsPlanType;

        private String paymentOption;

        private List<String> productTypes = DefaultSdkAutoConstructList.getInstance();

        private String currency;

        private String commitment;

        private String upfrontPaymentAmount;

        private String recurringPaymentAmount;

        private Long termDurationInSeconds;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String returnableUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlan model) {
            offeringId(model.offeringId);
            savingsPlanId(model.savingsPlanId);
            savingsPlanArn(model.savingsPlanArn);
            description(model.description);
            start(model.start);
            end(model.end);
            state(model.state);
            region(model.region);
            ec2InstanceFamily(model.ec2InstanceFamily);
            savingsPlanType(model.savingsPlanType);
            paymentOption(model.paymentOption);
            productTypesWithStrings(model.productTypes);
            currency(model.currency);
            commitment(model.commitment);
            upfrontPaymentAmount(model.upfrontPaymentAmount);
            recurringPaymentAmount(model.recurringPaymentAmount);
            termDurationInSeconds(model.termDurationInSeconds);
            tags(model.tags);
            returnableUntil(model.returnableUntil);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getSavingsPlanId() {
            return savingsPlanId;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        public final String getSavingsPlanArn() {
            return savingsPlanArn;
        }

        public final void setSavingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
        }

        @Override
        public final Builder savingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getEnd() {
            return end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SavingsPlanState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getEc2InstanceFamily() {
            return ec2InstanceFamily;
        }

        public final void setEc2InstanceFamily(String ec2InstanceFamily) {
            this.ec2InstanceFamily = ec2InstanceFamily;
        }

        @Override
        public final Builder ec2InstanceFamily(String ec2InstanceFamily) {
            this.ec2InstanceFamily = ec2InstanceFamily;
            return this;
        }

        public final String getSavingsPlanType() {
            return savingsPlanType;
        }

        public final void setSavingsPlanType(String savingsPlanType) {
            this.savingsPlanType = savingsPlanType;
        }

        @Override
        public final Builder savingsPlanType(String savingsPlanType) {
            this.savingsPlanType = savingsPlanType;
            return this;
        }

        @Override
        public final Builder savingsPlanType(SavingsPlanType savingsPlanType) {
            this.savingsPlanType(savingsPlanType == null ? null : savingsPlanType.toString());
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final Collection<String> getProductTypes() {
            if (productTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return productTypes;
        }

        public final void setProductTypes(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
        }

        @Override
        public final Builder productTypesWithStrings(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productTypesWithStrings(String... productTypes) {
            productTypesWithStrings(Arrays.asList(productTypes));
            return this;
        }

        @Override
        public final Builder productTypes(Collection<SavingsPlanProductType> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copyEnumToString(productTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productTypes(SavingsPlanProductType... productTypes) {
            productTypes(Arrays.asList(productTypes));
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getCommitment() {
            return commitment;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        @Override
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public final String getUpfrontPaymentAmount() {
            return upfrontPaymentAmount;
        }

        public final void setUpfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
        }

        @Override
        public final Builder upfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
            return this;
        }

        public final String getRecurringPaymentAmount() {
            return recurringPaymentAmount;
        }

        public final void setRecurringPaymentAmount(String recurringPaymentAmount) {
            this.recurringPaymentAmount = recurringPaymentAmount;
        }

        @Override
        public final Builder recurringPaymentAmount(String recurringPaymentAmount) {
            this.recurringPaymentAmount = recurringPaymentAmount;
            return this;
        }

        public final Long getTermDurationInSeconds() {
            return termDurationInSeconds;
        }

        public final void setTermDurationInSeconds(Long termDurationInSeconds) {
            this.termDurationInSeconds = termDurationInSeconds;
        }

        @Override
        public final Builder termDurationInSeconds(Long termDurationInSeconds) {
            this.termDurationInSeconds = termDurationInSeconds;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getReturnableUntil() {
            return returnableUntil;
        }

        public final void setReturnableUntil(String returnableUntil) {
            this.returnableUntil = returnableUntil;
        }

        @Override
        public final Builder returnableUntil(String returnableUntil) {
            this.returnableUntil = returnableUntil;
            return this;
        }

        @Override
        public SavingsPlan build() {
            return new SavingsPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
