/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansOfferingRatesResponse extends SavingsplansResponse implements
        ToCopyableBuilder<DescribeSavingsPlansOfferingRatesResponse.Builder, DescribeSavingsPlansOfferingRatesResponse> {
    private static final SdkField<List<SavingsPlanOfferingRate>> SEARCH_RESULTS_FIELD = SdkField
            .<List<SavingsPlanOfferingRate>> builder(MarshallingType.LIST)
            .memberName("searchResults")
            .getter(getter(DescribeSavingsPlansOfferingRatesResponse::searchResults))
            .setter(setter(Builder::searchResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOfferingRate> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOfferingRate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSavingsPlansOfferingRatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SavingsPlanOfferingRate> searchResults;

    private final String nextToken;

    private DescribeSavingsPlansOfferingRatesResponse(BuilderImpl builder) {
        super(builder);
        this.searchResults = builder.searchResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSearchResults() {
        return searchResults != null && !(searchResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Savings Plans offering rates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchResults} method.
     * </p>
     * 
     * @return Information about the Savings Plans offering rates.
     */
    public final List<SavingsPlanOfferingRate> searchResults() {
        return searchResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchResults() ? searchResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingRatesResponse)) {
            return false;
        }
        DescribeSavingsPlansOfferingRatesResponse other = (DescribeSavingsPlansOfferingRatesResponse) obj;
        return hasSearchResults() == other.hasSearchResults() && Objects.equals(searchResults(), other.searchResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSavingsPlansOfferingRatesResponse")
                .add("SearchResults", hasSearchResults() ? searchResults() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "searchResults":
            return Optional.ofNullable(clazz.cast(searchResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("searchResults", SEARCH_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingRatesResponse, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingRatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SavingsplansResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlansOfferingRatesResponse> {
        /**
         * <p>
         * Information about the Savings Plans offering rates.
         * </p>
         * 
         * @param searchResults
         *        Information about the Savings Plans offering rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResults(Collection<SavingsPlanOfferingRate> searchResults);

        /**
         * <p>
         * Information about the Savings Plans offering rates.
         * </p>
         * 
         * @param searchResults
         *        Information about the Savings Plans offering rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResults(SavingsPlanOfferingRate... searchResults);

        /**
         * <p>
         * Information about the Savings Plans offering rates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate.Builder#build()} is called
         * immediately and its result is passed to {@link #searchResults(List<SavingsPlanOfferingRate>)}.
         * 
         * @param searchResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchResults(java.util.Collection<SavingsPlanOfferingRate>)
         */
        Builder searchResults(Consumer<SavingsPlanOfferingRate.Builder>... searchResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SavingsplansResponse.BuilderImpl implements Builder {
        private List<SavingsPlanOfferingRate> searchResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingRatesResponse model) {
            super(model);
            searchResults(model.searchResults);
            nextToken(model.nextToken);
        }

        public final List<SavingsPlanOfferingRate.Builder> getSearchResults() {
            List<SavingsPlanOfferingRate.Builder> result = SavingsPlanOfferingRatesListCopier.copyToBuilder(this.searchResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchResults(Collection<SavingsPlanOfferingRate.BuilderImpl> searchResults) {
            this.searchResults = SavingsPlanOfferingRatesListCopier.copyFromBuilder(searchResults);
        }

        @Override
        public final Builder searchResults(Collection<SavingsPlanOfferingRate> searchResults) {
            this.searchResults = SavingsPlanOfferingRatesListCopier.copy(searchResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(SavingsPlanOfferingRate... searchResults) {
            searchResults(Arrays.asList(searchResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(Consumer<SavingsPlanOfferingRate.Builder>... searchResults) {
            searchResults(Stream.of(searchResults).map(c -> SavingsPlanOfferingRate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSavingsPlansOfferingRatesResponse build() {
            return new DescribeSavingsPlansOfferingRatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
