/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.savingsplans.model.CurrencyCode;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParentSavingsPlanOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParentSavingsPlanOffering> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offeringId").getter(ParentSavingsPlanOffering.getter(ParentSavingsPlanOffering::offeringId)).setter(ParentSavingsPlanOffering.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("paymentOption").getter(ParentSavingsPlanOffering.getter(ParentSavingsPlanOffering::paymentOptionAsString)).setter(ParentSavingsPlanOffering.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()}).build();
    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planType").getter(ParentSavingsPlanOffering.getter(ParentSavingsPlanOffering::planTypeAsString)).setter(ParentSavingsPlanOffering.setter(Builder::planType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planType").build()}).build();
    private static final SdkField<Long> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("durationSeconds").getter(ParentSavingsPlanOffering.getter(ParentSavingsPlanOffering::durationSeconds)).setter(ParentSavingsPlanOffering.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(ParentSavingsPlanOffering.getter(ParentSavingsPlanOffering::currencyAsString)).setter(ParentSavingsPlanOffering.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> PLAN_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planDescription").getter(ParentSavingsPlanOffering.getter(ParentSavingsPlanOffering::planDescription)).setter(ParentSavingsPlanOffering.setter(Builder::planDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD, PAYMENT_OPTION_FIELD, PLAN_TYPE_FIELD, DURATION_SECONDS_FIELD, CURRENCY_FIELD, PLAN_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParentSavingsPlanOffering.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String offeringId;
    private final String paymentOption;
    private final String planType;
    private final Long durationSeconds;
    private final String currency;
    private final String planDescription;

    private ParentSavingsPlanOffering(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.planType = builder.planType;
        this.durationSeconds = builder.durationSeconds;
        this.currency = builder.currency;
        this.planDescription = builder.planDescription;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final SavingsPlanType planType() {
        return SavingsPlanType.fromValue(this.planType);
    }

    public final String planTypeAsString() {
        return this.planType;
    }

    public final Long durationSeconds() {
        return this.durationSeconds;
    }

    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final String planDescription() {
        return this.planDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.planDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentSavingsPlanOffering)) {
            return false;
        }
        ParentSavingsPlanOffering other = (ParentSavingsPlanOffering)obj;
        return Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.planTypeAsString(), other.planTypeAsString()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.planDescription(), other.planDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ParentSavingsPlanOffering").add("OfferingId", (Object)this.offeringId()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("PlanType", (Object)this.planTypeAsString()).add("DurationSeconds", (Object)this.durationSeconds()).add("Currency", (Object)this.currencyAsString()).add("PlanDescription", (Object)this.planDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "paymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "planType": {
                return Optional.ofNullable(clazz.cast(this.planTypeAsString()));
            }
            case "durationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "planDescription": {
                return Optional.ofNullable(clazz.cast(this.planDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        map.put("planType", PLAN_TYPE_FIELD);
        map.put("durationSeconds", DURATION_SECONDS_FIELD);
        map.put("currency", CURRENCY_FIELD);
        map.put("planDescription", PLAN_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentSavingsPlanOffering, T> g) {
        return obj -> g.apply((ParentSavingsPlanOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String offeringId;
        private String paymentOption;
        private String planType;
        private Long durationSeconds;
        private String currency;
        private String planDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ParentSavingsPlanOffering model) {
            this.offeringId(model.offeringId);
            this.paymentOption(model.paymentOption);
            this.planType(model.planType);
            this.durationSeconds(model.durationSeconds);
            this.currency(model.currency);
            this.planDescription(model.planDescription);
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getPlanType() {
            return this.planType;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(SavingsPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final Long getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getPlanDescription() {
            return this.planDescription;
        }

        public final void setPlanDescription(String planDescription) {
            this.planDescription = planDescription;
        }

        @Override
        public final Builder planDescription(String planDescription) {
            this.planDescription = planDescription;
            return this;
        }

        public ParentSavingsPlanOffering build() {
            return new ParentSavingsPlanOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParentSavingsPlanOffering> {
        public Builder offeringId(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(SavingsPlanPaymentOption var1);

        public Builder planType(String var1);

        public Builder planType(SavingsPlanType var1);

        public Builder durationSeconds(Long var1);

        public Builder currency(String var1);

        public Builder currency(CurrencyCode var1);

        public Builder planDescription(String var1);
    }
}

