/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakerruntime.model.SageMakerRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeEndpointRequest
extends SageMakerRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointRequest.getter(InvokeEndpointRequest::endpointName)).setter(InvokeEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EndpointName").build()}).build();
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(InvokeEndpointRequest.getter(InvokeEndpointRequest::body)).setter(InvokeEndpointRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointRequest.getter(InvokeEndpointRequest::contentType)).setter(InvokeEndpointRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointRequest.getter(InvokeEndpointRequest::accept)).setter(InvokeEndpointRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()}).build();
    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointRequest.getter(InvokeEndpointRequest::customAttributes)).setter(InvokeEndpointRequest.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, BODY_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD, CUSTOM_ATTRIBUTES_FIELD));
    private final String endpointName;
    private final SdkBytes body;
    private final String contentType;
    private final String accept;
    private final String customAttributes;

    private InvokeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.customAttributes = builder.customAttributes;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public SdkBytes body() {
        return this.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public String accept() {
        return this.accept;
    }

    public String customAttributes() {
        return this.customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointRequest)) {
            return false;
        }
        InvokeEndpointRequest other = (InvokeEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.customAttributes(), other.customAttributes());
    }

    public String toString() {
        return ToString.builder((String)"InvokeEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("Body", (Object)this.body()).add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).add("CustomAttributes", (Object)this.customAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointRequest, T> g) {
        return obj -> g.apply((InvokeEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRuntimeRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private SdkBytes body;
        private String contentType;
        private String accept;
        private String customAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.body(model.body);
            this.contentType(model.contentType);
            this.accept(model.accept);
            this.customAttributes(model.customAttributes);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy((SdkBytes)body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getAccept() {
            return this.accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final String getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeEndpointRequest build() {
            return new InvokeEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder body(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder customAttributes(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

