/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchGetMetricsRequest;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchGetMetricsResponse;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest;
import software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse;

/**
 * Service client for accessing SageMaker Metrics asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Contains all data plane API operations and data types for Amazon SageMaker Metrics. Use these APIs to put and
 * retrieve (get) features related to your training run.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_metrics_BatchPutMetrics.html">BatchPutMetrics</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerMetricsAsyncClient extends AwsClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "metrics.sagemaker";

    /**
     * <p>
     * Used to retrieve training metrics from SageMaker.
     * </p>
     *
     * @param batchGetMetricsRequest
     * @return A Java Future containing the result of the BatchGetMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SageMakerMetricsAsyncClient.BatchGetMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchGetMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetMetricsResponse> batchGetMetrics(BatchGetMetricsRequest batchGetMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to retrieve training metrics from SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetMetricsRequest#builder()}
     * </p>
     *
     * @param batchGetMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakermetrics.model.BatchGetMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SageMakerMetricsAsyncClient.BatchGetMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchGetMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetMetricsResponse> batchGetMetrics(
            Consumer<BatchGetMetricsRequest.Builder> batchGetMetricsRequest) {
        return batchGetMetrics(BatchGetMetricsRequest.builder().applyMutation(batchGetMetricsRequest).build());
    }

    /**
     * <p>
     * Used to ingest training metrics into SageMaker. These metrics can be visualized in SageMaker Studio.
     * </p>
     *
     * @param batchPutMetricsRequest
     * @return A Java Future containing the result of the BatchPutMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SageMakerMetricsAsyncClient.BatchPutMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchPutMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutMetricsResponse> batchPutMetrics(BatchPutMetricsRequest batchPutMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to ingest training metrics into SageMaker. These metrics can be visualized in SageMaker Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutMetricsRequest#builder()}
     * </p>
     *
     * @param batchPutMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchPutMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SageMakerMetricsAsyncClient.BatchPutMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/BatchPutMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutMetricsResponse> batchPutMetrics(
            Consumer<BatchPutMetricsRequest.Builder> batchPutMetricsRequest) {
        return batchPutMetrics(BatchPutMetricsRequest.builder().applyMutation(batchPutMetricsRequest).build());
    }

    @Override
    default SageMakerMetricsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SageMakerMetricsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerMetricsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerMetricsAsyncClient}.
     */
    static SageMakerMetricsAsyncClientBuilder builder() {
        return new DefaultSageMakerMetricsAsyncClientBuilder();
    }
}
