/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportErrorType {
    CLIENT_ERROR("CLIENT_ERROR"),
    SERVER_ERROR("SERVER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportErrorType> VALUE_MAP;
    private final String value;

    private ExportErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportErrorType> knownValues() {
        EnumSet<ExportErrorType> knownValues = EnumSet.allOf(ExportErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportErrorType.class, ExportErrorType::toString);
    }
}

