/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.DataCollectionType;
import software.amazon.awssdk.services.sagemakergeospatial.model.Filter;
import software.amazon.awssdk.services.sagemakergeospatial.model.FilterListCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.ImageSourceBandListCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRasterDataCollectionResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, GetRasterDataCollectionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::arn)).setter(GetRasterDataCollectionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::description)).setter(GetRasterDataCollectionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESCRIPTION_PAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DescriptionPageUrl").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::descriptionPageUrl)).setter(GetRasterDataCollectionResponse.setter(Builder::descriptionPageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescriptionPageUrl").build()}).build();
    private static final SdkField<List<String>> IMAGE_SOURCE_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageSourceBands").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::imageSourceBands)).setter(GetRasterDataCollectionResponse.setter(Builder::imageSourceBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSourceBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::name)).setter(GetRasterDataCollectionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<Filter>> SUPPORTED_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedFilters").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::supportedFilters)).setter(GetRasterDataCollectionResponse.setter(Builder::supportedFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::tags)).setter(GetRasterDataCollectionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetRasterDataCollectionResponse.getter(GetRasterDataCollectionResponse::typeAsString)).setter(GetRasterDataCollectionResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, DESCRIPTION_PAGE_URL_FIELD, IMAGE_SOURCE_BANDS_FIELD, NAME_FIELD, SUPPORTED_FILTERS_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRasterDataCollectionResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String description;
    private final String descriptionPageUrl;
    private final List<String> imageSourceBands;
    private final String name;
    private final List<Filter> supportedFilters;
    private final Map<String, String> tags;
    private final String type;

    private GetRasterDataCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.descriptionPageUrl = builder.descriptionPageUrl;
        this.imageSourceBands = builder.imageSourceBands;
        this.name = builder.name;
        this.supportedFilters = builder.supportedFilters;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String descriptionPageUrl() {
        return this.descriptionPageUrl;
    }

    public final boolean hasImageSourceBands() {
        return this.imageSourceBands != null && !(this.imageSourceBands instanceof SdkAutoConstructList);
    }

    public final List<String> imageSourceBands() {
        return this.imageSourceBands;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSupportedFilters() {
        return this.supportedFilters != null && !(this.supportedFilters instanceof SdkAutoConstructList);
    }

    public final List<Filter> supportedFilters() {
        return this.supportedFilters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DataCollectionType type() {
        return DataCollectionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptionPageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageSourceBands() ? this.imageSourceBands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFilters() ? this.supportedFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRasterDataCollectionResponse)) {
            return false;
        }
        GetRasterDataCollectionResponse other = (GetRasterDataCollectionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.descriptionPageUrl(), other.descriptionPageUrl()) && this.hasImageSourceBands() == other.hasImageSourceBands() && Objects.equals(this.imageSourceBands(), other.imageSourceBands()) && Objects.equals(this.name(), other.name()) && this.hasSupportedFilters() == other.hasSupportedFilters() && Objects.equals(this.supportedFilters(), other.supportedFilters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRasterDataCollectionResponse").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("DescriptionPageUrl", (Object)this.descriptionPageUrl()).add("ImageSourceBands", this.hasImageSourceBands() ? this.imageSourceBands() : null).add("Name", (Object)this.name()).add("SupportedFilters", this.hasSupportedFilters() ? this.supportedFilters() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DescriptionPageUrl": {
                return Optional.ofNullable(clazz.cast(this.descriptionPageUrl()));
            }
            case "ImageSourceBands": {
                return Optional.ofNullable(clazz.cast(this.imageSourceBands()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SupportedFilters": {
                return Optional.ofNullable(clazz.cast(this.supportedFilters()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DescriptionPageUrl", DESCRIPTION_PAGE_URL_FIELD);
        map.put("ImageSourceBands", IMAGE_SOURCE_BANDS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SupportedFilters", SUPPORTED_FILTERS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRasterDataCollectionResponse, T> g) {
        return obj -> g.apply((GetRasterDataCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private String descriptionPageUrl;
        private List<String> imageSourceBands = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<Filter> supportedFilters = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRasterDataCollectionResponse model) {
            super(model);
            this.arn(model.arn);
            this.description(model.description);
            this.descriptionPageUrl(model.descriptionPageUrl);
            this.imageSourceBands(model.imageSourceBands);
            this.name(model.name);
            this.supportedFilters(model.supportedFilters);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDescriptionPageUrl() {
            return this.descriptionPageUrl;
        }

        public final void setDescriptionPageUrl(String descriptionPageUrl) {
            this.descriptionPageUrl = descriptionPageUrl;
        }

        @Override
        public final Builder descriptionPageUrl(String descriptionPageUrl) {
            this.descriptionPageUrl = descriptionPageUrl;
            return this;
        }

        public final Collection<String> getImageSourceBands() {
            if (this.imageSourceBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageSourceBands;
        }

        public final void setImageSourceBands(Collection<String> imageSourceBands) {
            this.imageSourceBands = ImageSourceBandListCopier.copy(imageSourceBands);
        }

        @Override
        public final Builder imageSourceBands(Collection<String> imageSourceBands) {
            this.imageSourceBands = ImageSourceBandListCopier.copy(imageSourceBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSourceBands(String ... imageSourceBands) {
            this.imageSourceBands(Arrays.asList(imageSourceBands));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Filter.Builder> getSupportedFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.supportedFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedFilters(Collection<Filter.BuilderImpl> supportedFilters) {
            this.supportedFilters = FilterListCopier.copyFromBuilder(supportedFilters);
        }

        @Override
        public final Builder supportedFilters(Collection<Filter> supportedFilters) {
            this.supportedFilters = FilterListCopier.copy(supportedFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilters(Filter ... supportedFilters) {
            this.supportedFilters(Arrays.asList(supportedFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilters(Consumer<Filter.Builder> ... supportedFilters) {
            this.supportedFilters(Stream.of(supportedFilters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataCollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetRasterDataCollectionResponse build() {
            return new GetRasterDataCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRasterDataCollectionResponse> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder descriptionPageUrl(String var1);

        public Builder imageSourceBands(Collection<String> var1);

        public Builder imageSourceBands(String ... var1);

        public Builder name(String var1);

        public Builder supportedFilters(Collection<Filter> var1);

        public Builder supportedFilters(Filter ... var1);

        public Builder supportedFilters(Consumer<Filter.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(DataCollectionType var1);
    }
}

