/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.AlgorithmNameResampling;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionResamplingInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResamplingConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResamplingConfigInput> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(ResamplingConfigInput.getter(ResamplingConfigInput::algorithmNameAsString)).setter(ResamplingConfigInput.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final SdkField<OutputResolutionResamplingInput> OUTPUT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputResolution").getter(ResamplingConfigInput.getter(ResamplingConfigInput::outputResolution)).setter(ResamplingConfigInput.setter(Builder::outputResolution)).constructor(OutputResolutionResamplingInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputResolution").build()}).build();
    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetBands").getter(ResamplingConfigInput.getter(ResamplingConfigInput::targetBands)).setter(ResamplingConfigInput.setter(Builder::targetBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD, OUTPUT_RESOLUTION_FIELD, TARGET_BANDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AlgorithmName", ALGORITHM_NAME_FIELD);
            this.put("OutputResolution", OUTPUT_RESOLUTION_FIELD);
            this.put("TargetBands", TARGET_BANDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String algorithmName;
    private final OutputResolutionResamplingInput outputResolution;
    private final List<String> targetBands;

    private ResamplingConfigInput(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.outputResolution = builder.outputResolution;
        this.targetBands = builder.targetBands;
    }

    public final AlgorithmNameResampling algorithmName() {
        return AlgorithmNameResampling.fromValue(this.algorithmName);
    }

    public final String algorithmNameAsString() {
        return this.algorithmName;
    }

    public final OutputResolutionResamplingInput outputResolution() {
        return this.outputResolution;
    }

    public final boolean hasTargetBands() {
        return this.targetBands != null && !(this.targetBands instanceof SdkAutoConstructList);
    }

    public final List<String> targetBands() {
        return this.targetBands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetBands() ? this.targetBands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResamplingConfigInput)) {
            return false;
        }
        ResamplingConfigInput other = (ResamplingConfigInput)obj;
        return Objects.equals(this.algorithmNameAsString(), other.algorithmNameAsString()) && Objects.equals(this.outputResolution(), other.outputResolution()) && this.hasTargetBands() == other.hasTargetBands() && Objects.equals(this.targetBands(), other.targetBands());
    }

    public final String toString() {
        return ToString.builder((String)"ResamplingConfigInput").add("AlgorithmName", (Object)this.algorithmNameAsString()).add("OutputResolution", (Object)this.outputResolution()).add("TargetBands", this.hasTargetBands() ? this.targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmNameAsString()));
            }
            case "OutputResolution": {
                return Optional.ofNullable(clazz.cast(this.outputResolution()));
            }
            case "TargetBands": {
                return Optional.ofNullable(clazz.cast(this.targetBands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResamplingConfigInput, T> g) {
        return obj -> g.apply((ResamplingConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithmName;
        private OutputResolutionResamplingInput outputResolution;
        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResamplingConfigInput model) {
            this.algorithmName(model.algorithmName);
            this.outputResolution(model.outputResolution);
            this.targetBands(model.targetBands);
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        @Override
        public final Builder algorithmName(AlgorithmNameResampling algorithmName) {
            this.algorithmName(algorithmName == null ? null : algorithmName.toString());
            return this;
        }

        public final OutputResolutionResamplingInput.Builder getOutputResolution() {
            return this.outputResolution != null ? this.outputResolution.toBuilder() : null;
        }

        public final void setOutputResolution(OutputResolutionResamplingInput.BuilderImpl outputResolution) {
            this.outputResolution = outputResolution != null ? outputResolution.build() : null;
        }

        @Override
        public final Builder outputResolution(OutputResolutionResamplingInput outputResolution) {
            this.outputResolution = outputResolution;
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (this.targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String ... targetBands) {
            this.targetBands(Arrays.asList(targetBands));
            return this;
        }

        public ResamplingConfigInput build() {
            return new ResamplingConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResamplingConfigInput> {
        public Builder algorithmName(String var1);

        public Builder algorithmName(AlgorithmNameResampling var1);

        public Builder outputResolution(OutputResolutionResamplingInput var1);

        default public Builder outputResolution(Consumer<OutputResolutionResamplingInput.Builder> outputResolution) {
            return this.outputResolution((OutputResolutionResamplingInput)((OutputResolutionResamplingInput.Builder)OutputResolutionResamplingInput.builder().applyMutation(outputResolution)).build());
        }

        public Builder targetBands(Collection<String> var1);

        public Builder targetBands(String ... var1);
    }
}

