/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRasterDataCollectionRequest
extends SageMakerGeospatialRequest
implements ToCopyableBuilder<Builder, SearchRasterDataCollectionRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(SearchRasterDataCollectionRequest.getter(SearchRasterDataCollectionRequest::arn)).setter(SearchRasterDataCollectionRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchRasterDataCollectionRequest.getter(SearchRasterDataCollectionRequest::nextToken)).setter(SearchRasterDataCollectionRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<RasterDataCollectionQueryWithBandFilterInput> RASTER_DATA_COLLECTION_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RasterDataCollectionQuery").getter(SearchRasterDataCollectionRequest.getter(SearchRasterDataCollectionRequest::rasterDataCollectionQuery)).setter(SearchRasterDataCollectionRequest.setter(Builder::rasterDataCollectionQuery)).constructor(RasterDataCollectionQueryWithBandFilterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NEXT_TOKEN_FIELD, RASTER_DATA_COLLECTION_QUERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RasterDataCollectionQuery", RASTER_DATA_COLLECTION_QUERY_FIELD);
        }
    });
    private final String arn;
    private final String nextToken;
    private final RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery;

    private SearchRasterDataCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.nextToken = builder.nextToken;
        this.rasterDataCollectionQuery = builder.rasterDataCollectionQuery;
    }

    public final String arn() {
        return this.arn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery() {
        return this.rasterDataCollectionQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.rasterDataCollectionQuery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRasterDataCollectionRequest)) {
            return false;
        }
        SearchRasterDataCollectionRequest other = (SearchRasterDataCollectionRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.rasterDataCollectionQuery(), other.rasterDataCollectionQuery());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRasterDataCollectionRequest").add("Arn", (Object)this.arn()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RasterDataCollectionQuery", (Object)this.rasterDataCollectionQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RasterDataCollectionQuery": {
                return Optional.ofNullable(clazz.cast(this.rasterDataCollectionQuery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchRasterDataCollectionRequest, T> g) {
        return obj -> g.apply((SearchRasterDataCollectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String nextToken;
        private RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRasterDataCollectionRequest model) {
            super(model);
            this.arn(model.arn);
            this.nextToken(model.nextToken);
            this.rasterDataCollectionQuery(model.rasterDataCollectionQuery);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final RasterDataCollectionQueryWithBandFilterInput.Builder getRasterDataCollectionQuery() {
            return this.rasterDataCollectionQuery != null ? this.rasterDataCollectionQuery.toBuilder() : null;
        }

        public final void setRasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput.BuilderImpl rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery != null ? rasterDataCollectionQuery.build() : null;
        }

        @Override
        public final Builder rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput rasterDataCollectionQuery) {
            this.rasterDataCollectionQuery = rasterDataCollectionQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRasterDataCollectionRequest build() {
            return new SearchRasterDataCollectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchRasterDataCollectionRequest> {
        public Builder arn(String var1);

        public Builder nextToken(String var1);

        public Builder rasterDataCollectionQuery(RasterDataCollectionQueryWithBandFilterInput var1);

        default public Builder rasterDataCollectionQuery(Consumer<RasterDataCollectionQueryWithBandFilterInput.Builder> rasterDataCollectionQuery) {
            return this.rasterDataCollectionQuery((RasterDataCollectionQueryWithBandFilterInput)((RasterDataCollectionQueryWithBandFilterInput.Builder)RasterDataCollectionQueryWithBandFilterInput.builder().applyMutation(rasterDataCollectionQuery)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

