/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.DataCollectionsListCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRasterDataCollectionsResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, ListRasterDataCollectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRasterDataCollectionsResponse.getter(ListRasterDataCollectionsResponse::nextToken)).setter(ListRasterDataCollectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RasterDataCollectionMetadata>> RASTER_DATA_COLLECTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RasterDataCollectionSummaries").getter(ListRasterDataCollectionsResponse.getter(ListRasterDataCollectionsResponse::rasterDataCollectionSummaries)).setter(ListRasterDataCollectionsResponse.setter(Builder::rasterDataCollectionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RasterDataCollectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RASTER_DATA_COLLECTION_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RasterDataCollectionSummaries", RASTER_DATA_COLLECTION_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<RasterDataCollectionMetadata> rasterDataCollectionSummaries;

    private ListRasterDataCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.rasterDataCollectionSummaries = builder.rasterDataCollectionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRasterDataCollectionSummaries() {
        return this.rasterDataCollectionSummaries != null && !(this.rasterDataCollectionSummaries instanceof SdkAutoConstructList);
    }

    public final List<RasterDataCollectionMetadata> rasterDataCollectionSummaries() {
        return this.rasterDataCollectionSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRasterDataCollectionSummaries() ? this.rasterDataCollectionSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRasterDataCollectionsResponse)) {
            return false;
        }
        ListRasterDataCollectionsResponse other = (ListRasterDataCollectionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRasterDataCollectionSummaries() == other.hasRasterDataCollectionSummaries() && Objects.equals(this.rasterDataCollectionSummaries(), other.rasterDataCollectionSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListRasterDataCollectionsResponse").add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RasterDataCollectionSummaries", this.hasRasterDataCollectionSummaries() ? this.rasterDataCollectionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RasterDataCollectionSummaries": {
                return Optional.ofNullable(clazz.cast(this.rasterDataCollectionSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRasterDataCollectionsResponse, T> g) {
        return obj -> g.apply((ListRasterDataCollectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RasterDataCollectionMetadata> rasterDataCollectionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRasterDataCollectionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.rasterDataCollectionSummaries(model.rasterDataCollectionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RasterDataCollectionMetadata.Builder> getRasterDataCollectionSummaries() {
            List<RasterDataCollectionMetadata.Builder> result = DataCollectionsListCopier.copyToBuilder(this.rasterDataCollectionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRasterDataCollectionSummaries(Collection<RasterDataCollectionMetadata.BuilderImpl> rasterDataCollectionSummaries) {
            this.rasterDataCollectionSummaries = DataCollectionsListCopier.copyFromBuilder(rasterDataCollectionSummaries);
        }

        @Override
        public final Builder rasterDataCollectionSummaries(Collection<RasterDataCollectionMetadata> rasterDataCollectionSummaries) {
            this.rasterDataCollectionSummaries = DataCollectionsListCopier.copy(rasterDataCollectionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rasterDataCollectionSummaries(RasterDataCollectionMetadata ... rasterDataCollectionSummaries) {
            this.rasterDataCollectionSummaries(Arrays.asList(rasterDataCollectionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rasterDataCollectionSummaries(Consumer<RasterDataCollectionMetadata.Builder> ... rasterDataCollectionSummaries) {
            this.rasterDataCollectionSummaries(Stream.of(rasterDataCollectionSummaries).map(c -> (RasterDataCollectionMetadata)((RasterDataCollectionMetadata.Builder)RasterDataCollectionMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRasterDataCollectionsResponse build() {
            return new ListRasterDataCollectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRasterDataCollectionsResponse> {
        public Builder nextToken(String var1);

        public Builder rasterDataCollectionSummaries(Collection<RasterDataCollectionMetadata> var1);

        public Builder rasterDataCollectionSummaries(RasterDataCollectionMetadata ... var1);

        public Builder rasterDataCollectionSummaries(Consumer<RasterDataCollectionMetadata.Builder> ... var1);
    }
}

