/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialAsyncClient;
import software.amazon.awssdk.services.sagemakergeospatial.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse;

public class ListEarthObservationJobsPublisher
implements SdkPublisher<ListEarthObservationJobsResponse> {
    private final SageMakerGeospatialAsyncClient client;
    private final ListEarthObservationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEarthObservationJobsPublisher(SageMakerGeospatialAsyncClient client, ListEarthObservationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEarthObservationJobsPublisher(SageMakerGeospatialAsyncClient client, ListEarthObservationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEarthObservationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEarthObservationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListEarthObservationJobOutputConfig> earthObservationJobSummaries() {
        Function<ListEarthObservationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.earthObservationJobSummaries() != null) {
                return response.earthObservationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEarthObservationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEarthObservationJobsResponseFetcher
    implements AsyncPageFetcher<ListEarthObservationJobsResponse> {
        private ListEarthObservationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEarthObservationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEarthObservationJobsResponse> nextPage(ListEarthObservationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEarthObservationJobsPublisher.this.client.listEarthObservationJobs(ListEarthObservationJobsPublisher.this.firstRequest);
            }
            return ListEarthObservationJobsPublisher.this.client.listEarthObservationJobs((ListEarthObservationJobsRequest)((Object)ListEarthObservationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

