/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialAsyncClient;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata;

public class ListRasterDataCollectionsPublisher
implements SdkPublisher<ListRasterDataCollectionsResponse> {
    private final SageMakerGeospatialAsyncClient client;
    private final ListRasterDataCollectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRasterDataCollectionsPublisher(SageMakerGeospatialAsyncClient client, ListRasterDataCollectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRasterDataCollectionsPublisher(SageMakerGeospatialAsyncClient client, ListRasterDataCollectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRasterDataCollectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRasterDataCollectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RasterDataCollectionMetadata> rasterDataCollectionSummaries() {
        Function<ListRasterDataCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rasterDataCollectionSummaries() != null) {
                return response.rasterDataCollectionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRasterDataCollectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRasterDataCollectionsResponseFetcher
    implements AsyncPageFetcher<ListRasterDataCollectionsResponse> {
        private ListRasterDataCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRasterDataCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRasterDataCollectionsResponse> nextPage(ListRasterDataCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListRasterDataCollectionsPublisher.this.client.listRasterDataCollections(ListRasterDataCollectionsPublisher.this.firstRequest);
            }
            return ListRasterDataCollectionsPublisher.this.client.listRasterDataCollections((ListRasterDataCollectionsRequest)((Object)ListRasterDataCollectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

