/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest;
import software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters;
import software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RasterDataCollectionQueryOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RasterDataCollectionQueryOutput> {
    private static final SdkField<AreaOfInterest> AREA_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AreaOfInterest").getter(RasterDataCollectionQueryOutput.getter(RasterDataCollectionQueryOutput::areaOfInterest)).setter(RasterDataCollectionQueryOutput.setter(Builder::areaOfInterest)).constructor(AreaOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaOfInterest").build()}).build();
    private static final SdkField<PropertyFilters> PROPERTY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PropertyFilters").getter(RasterDataCollectionQueryOutput.getter(RasterDataCollectionQueryOutput::propertyFilters)).setter(RasterDataCollectionQueryOutput.setter(Builder::propertyFilters)).constructor(PropertyFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFilters").build()}).build();
    private static final SdkField<String> RASTER_DATA_COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RasterDataCollectionArn").getter(RasterDataCollectionQueryOutput.getter(RasterDataCollectionQueryOutput::rasterDataCollectionArn)).setter(RasterDataCollectionQueryOutput.setter(Builder::rasterDataCollectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionArn").build()}).build();
    private static final SdkField<String> RASTER_DATA_COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RasterDataCollectionName").getter(RasterDataCollectionQueryOutput.getter(RasterDataCollectionQueryOutput::rasterDataCollectionName)).setter(RasterDataCollectionQueryOutput.setter(Builder::rasterDataCollectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionName").build()}).build();
    private static final SdkField<TimeRangeFilterOutput> TIME_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRangeFilter").getter(RasterDataCollectionQueryOutput.getter(RasterDataCollectionQueryOutput::timeRangeFilter)).setter(RasterDataCollectionQueryOutput.setter(Builder::timeRangeFilter)).constructor(TimeRangeFilterOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_OF_INTEREST_FIELD, PROPERTY_FILTERS_FIELD, RASTER_DATA_COLLECTION_ARN_FIELD, RASTER_DATA_COLLECTION_NAME_FIELD, TIME_RANGE_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final AreaOfInterest areaOfInterest;
    private final PropertyFilters propertyFilters;
    private final String rasterDataCollectionArn;
    private final String rasterDataCollectionName;
    private final TimeRangeFilterOutput timeRangeFilter;

    private RasterDataCollectionQueryOutput(BuilderImpl builder) {
        this.areaOfInterest = builder.areaOfInterest;
        this.propertyFilters = builder.propertyFilters;
        this.rasterDataCollectionArn = builder.rasterDataCollectionArn;
        this.rasterDataCollectionName = builder.rasterDataCollectionName;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    public final AreaOfInterest areaOfInterest() {
        return this.areaOfInterest;
    }

    public final PropertyFilters propertyFilters() {
        return this.propertyFilters;
    }

    public final String rasterDataCollectionArn() {
        return this.rasterDataCollectionArn;
    }

    public final String rasterDataCollectionName() {
        return this.rasterDataCollectionName;
    }

    public final TimeRangeFilterOutput timeRangeFilter() {
        return this.timeRangeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.areaOfInterest());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.rasterDataCollectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rasterDataCollectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionQueryOutput)) {
            return false;
        }
        RasterDataCollectionQueryOutput other = (RasterDataCollectionQueryOutput)obj;
        return Objects.equals(this.areaOfInterest(), other.areaOfInterest()) && Objects.equals(this.propertyFilters(), other.propertyFilters()) && Objects.equals(this.rasterDataCollectionArn(), other.rasterDataCollectionArn()) && Objects.equals(this.rasterDataCollectionName(), other.rasterDataCollectionName()) && Objects.equals(this.timeRangeFilter(), other.timeRangeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"RasterDataCollectionQueryOutput").add("AreaOfInterest", (Object)this.areaOfInterest()).add("PropertyFilters", (Object)this.propertyFilters()).add("RasterDataCollectionArn", (Object)this.rasterDataCollectionArn()).add("RasterDataCollectionName", (Object)this.rasterDataCollectionName()).add("TimeRangeFilter", (Object)(this.timeRangeFilter() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AreaOfInterest": {
                return Optional.ofNullable(clazz.cast(this.areaOfInterest()));
            }
            case "PropertyFilters": {
                return Optional.ofNullable(clazz.cast(this.propertyFilters()));
            }
            case "RasterDataCollectionArn": {
                return Optional.ofNullable(clazz.cast(this.rasterDataCollectionArn()));
            }
            case "RasterDataCollectionName": {
                return Optional.ofNullable(clazz.cast(this.rasterDataCollectionName()));
            }
            case "TimeRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeRangeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RasterDataCollectionQueryOutput, T> g) {
        return obj -> g.apply((RasterDataCollectionQueryOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AreaOfInterest areaOfInterest;
        private PropertyFilters propertyFilters;
        private String rasterDataCollectionArn;
        private String rasterDataCollectionName;
        private TimeRangeFilterOutput timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(RasterDataCollectionQueryOutput model) {
            this.areaOfInterest(model.areaOfInterest);
            this.propertyFilters(model.propertyFilters);
            this.rasterDataCollectionArn(model.rasterDataCollectionArn);
            this.rasterDataCollectionName(model.rasterDataCollectionName);
            this.timeRangeFilter(model.timeRangeFilter);
        }

        public final AreaOfInterest.Builder getAreaOfInterest() {
            return this.areaOfInterest != null ? this.areaOfInterest.toBuilder() : null;
        }

        public final void setAreaOfInterest(AreaOfInterest.BuilderImpl areaOfInterest) {
            this.areaOfInterest = areaOfInterest != null ? areaOfInterest.build() : null;
        }

        @Override
        public final Builder areaOfInterest(AreaOfInterest areaOfInterest) {
            this.areaOfInterest = areaOfInterest;
            return this;
        }

        public final PropertyFilters.Builder getPropertyFilters() {
            return this.propertyFilters != null ? this.propertyFilters.toBuilder() : null;
        }

        public final void setPropertyFilters(PropertyFilters.BuilderImpl propertyFilters) {
            this.propertyFilters = propertyFilters != null ? propertyFilters.build() : null;
        }

        @Override
        public final Builder propertyFilters(PropertyFilters propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final String getRasterDataCollectionArn() {
            return this.rasterDataCollectionArn;
        }

        public final void setRasterDataCollectionArn(String rasterDataCollectionArn) {
            this.rasterDataCollectionArn = rasterDataCollectionArn;
        }

        @Override
        public final Builder rasterDataCollectionArn(String rasterDataCollectionArn) {
            this.rasterDataCollectionArn = rasterDataCollectionArn;
            return this;
        }

        public final String getRasterDataCollectionName() {
            return this.rasterDataCollectionName;
        }

        public final void setRasterDataCollectionName(String rasterDataCollectionName) {
            this.rasterDataCollectionName = rasterDataCollectionName;
        }

        @Override
        public final Builder rasterDataCollectionName(String rasterDataCollectionName) {
            this.rasterDataCollectionName = rasterDataCollectionName;
            return this;
        }

        public final TimeRangeFilterOutput.Builder getTimeRangeFilter() {
            return this.timeRangeFilter != null ? this.timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilterOutput.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilterOutput timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public RasterDataCollectionQueryOutput build() {
            return new RasterDataCollectionQueryOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RasterDataCollectionQueryOutput> {
        public Builder areaOfInterest(AreaOfInterest var1);

        default public Builder areaOfInterest(Consumer<AreaOfInterest.Builder> areaOfInterest) {
            return this.areaOfInterest((AreaOfInterest)((AreaOfInterest.Builder)AreaOfInterest.builder().applyMutation(areaOfInterest)).build());
        }

        public Builder propertyFilters(PropertyFilters var1);

        default public Builder propertyFilters(Consumer<PropertyFilters.Builder> propertyFilters) {
            return this.propertyFilters((PropertyFilters)((PropertyFilters.Builder)PropertyFilters.builder().applyMutation(propertyFilters)).build());
        }

        public Builder rasterDataCollectionArn(String var1);

        public Builder rasterDataCollectionName(String var1);

        public Builder timeRangeFilter(TimeRangeFilterOutput var1);

        default public Builder timeRangeFilter(Consumer<TimeRangeFilterOutput.Builder> timeRangeFilter) {
            return this.timeRangeFilter((TimeRangeFilterOutput)((TimeRangeFilterOutput.Builder)TimeRangeFilterOutput.builder().applyMutation(timeRangeFilter)).build());
        }
    }
}

