/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemakergeospatial.DefaultSageMakerGeospatialClientBuilder;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialClientBuilder;
import software.amazon.awssdk.services.sagemakergeospatial.model.AccessDeniedException;
import software.amazon.awssdk.services.sagemakergeospatial.model.ConflictException;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetTileResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.InternalServerException;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialException;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ThrottlingException;
import software.amazon.awssdk.services.sagemakergeospatial.model.UntagResourceRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.UntagResourceResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.ValidationException;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.ListEarthObservationJobsIterable;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.ListRasterDataCollectionsIterable;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.ListVectorEnrichmentJobsIterable;
import software.amazon.awssdk.services.sagemakergeospatial.paginators.SearchRasterDataCollectionIterable;

@SdkPublicApi
@ThreadSafe
public interface SageMakerGeospatialClient
extends SdkClient {
    public static final String SERVICE_NAME = "sagemaker-geospatial";
    public static final String SERVICE_METADATA_ID = "sagemaker-geospatial";

    public static SageMakerGeospatialClient create() {
        return (SageMakerGeospatialClient)SageMakerGeospatialClient.builder().build();
    }

    public static SageMakerGeospatialClientBuilder builder() {
        return new DefaultSageMakerGeospatialClientBuilder();
    }

    default public DeleteEarthObservationJobResponse deleteEarthObservationJob(DeleteEarthObservationJobRequest deleteEarthObservationJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public DeleteEarthObservationJobResponse deleteEarthObservationJob(Consumer<DeleteEarthObservationJobRequest.Builder> deleteEarthObservationJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.deleteEarthObservationJob((DeleteEarthObservationJobRequest)((Object)((DeleteEarthObservationJobRequest.Builder)DeleteEarthObservationJobRequest.builder().applyMutation(deleteEarthObservationJobRequest)).build()));
    }

    default public DeleteVectorEnrichmentJobResponse deleteVectorEnrichmentJob(DeleteVectorEnrichmentJobRequest deleteVectorEnrichmentJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVectorEnrichmentJobResponse deleteVectorEnrichmentJob(Consumer<DeleteVectorEnrichmentJobRequest.Builder> deleteVectorEnrichmentJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.deleteVectorEnrichmentJob((DeleteVectorEnrichmentJobRequest)((Object)((DeleteVectorEnrichmentJobRequest.Builder)DeleteVectorEnrichmentJobRequest.builder().applyMutation(deleteVectorEnrichmentJobRequest)).build()));
    }

    default public ExportEarthObservationJobResponse exportEarthObservationJob(ExportEarthObservationJobRequest exportEarthObservationJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ExportEarthObservationJobResponse exportEarthObservationJob(Consumer<ExportEarthObservationJobRequest.Builder> exportEarthObservationJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.exportEarthObservationJob((ExportEarthObservationJobRequest)((Object)((ExportEarthObservationJobRequest.Builder)ExportEarthObservationJobRequest.builder().applyMutation(exportEarthObservationJobRequest)).build()));
    }

    default public ExportVectorEnrichmentJobResponse exportVectorEnrichmentJob(ExportVectorEnrichmentJobRequest exportVectorEnrichmentJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ExportVectorEnrichmentJobResponse exportVectorEnrichmentJob(Consumer<ExportVectorEnrichmentJobRequest.Builder> exportVectorEnrichmentJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.exportVectorEnrichmentJob((ExportVectorEnrichmentJobRequest)((Object)((ExportVectorEnrichmentJobRequest.Builder)ExportVectorEnrichmentJobRequest.builder().applyMutation(exportVectorEnrichmentJobRequest)).build()));
    }

    default public GetEarthObservationJobResponse getEarthObservationJob(GetEarthObservationJobRequest getEarthObservationJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public GetEarthObservationJobResponse getEarthObservationJob(Consumer<GetEarthObservationJobRequest.Builder> getEarthObservationJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getEarthObservationJob((GetEarthObservationJobRequest)((Object)((GetEarthObservationJobRequest.Builder)GetEarthObservationJobRequest.builder().applyMutation(getEarthObservationJobRequest)).build()));
    }

    default public GetRasterDataCollectionResponse getRasterDataCollection(GetRasterDataCollectionRequest getRasterDataCollectionRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public GetRasterDataCollectionResponse getRasterDataCollection(Consumer<GetRasterDataCollectionRequest.Builder> getRasterDataCollectionRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getRasterDataCollection((GetRasterDataCollectionRequest)((Object)((GetRasterDataCollectionRequest.Builder)GetRasterDataCollectionRequest.builder().applyMutation(getRasterDataCollectionRequest)).build()));
    }

    default public <ReturnT> ReturnT getTile(GetTileRequest getTileRequest, ResponseTransformer<GetTileResponse, ReturnT> responseTransformer) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getTile(Consumer<GetTileRequest.Builder> getTileRequest, ResponseTransformer<GetTileResponse, ReturnT> responseTransformer) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getTile((GetTileRequest)((Object)((GetTileRequest.Builder)GetTileRequest.builder().applyMutation(getTileRequest)).build()), responseTransformer);
    }

    default public GetTileResponse getTile(GetTileRequest getTileRequest, Path destinationPath) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return (GetTileResponse)((Object)this.getTile(getTileRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetTileResponse getTile(Consumer<GetTileRequest.Builder> getTileRequest, Path destinationPath) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getTile((GetTileRequest)((Object)((GetTileRequest.Builder)GetTileRequest.builder().applyMutation(getTileRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetTileResponse> getTile(GetTileRequest getTileRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return (ResponseInputStream)this.getTile(getTileRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetTileResponse> getTile(Consumer<GetTileRequest.Builder> getTileRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getTile((GetTileRequest)((Object)((GetTileRequest.Builder)GetTileRequest.builder().applyMutation(getTileRequest)).build()));
    }

    default public ResponseBytes<GetTileResponse> getTileAsBytes(GetTileRequest getTileRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return (ResponseBytes)this.getTile(getTileRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetTileResponse> getTileAsBytes(Consumer<GetTileRequest.Builder> getTileRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getTileAsBytes((GetTileRequest)((Object)((GetTileRequest.Builder)GetTileRequest.builder().applyMutation(getTileRequest)).build()));
    }

    default public GetVectorEnrichmentJobResponse getVectorEnrichmentJob(GetVectorEnrichmentJobRequest getVectorEnrichmentJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public GetVectorEnrichmentJobResponse getVectorEnrichmentJob(Consumer<GetVectorEnrichmentJobRequest.Builder> getVectorEnrichmentJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.getVectorEnrichmentJob((GetVectorEnrichmentJobRequest)((Object)((GetVectorEnrichmentJobRequest.Builder)GetVectorEnrichmentJobRequest.builder().applyMutation(getVectorEnrichmentJobRequest)).build()));
    }

    default public ListEarthObservationJobsResponse listEarthObservationJobs(ListEarthObservationJobsRequest listEarthObservationJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListEarthObservationJobsResponse listEarthObservationJobs(Consumer<ListEarthObservationJobsRequest.Builder> listEarthObservationJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listEarthObservationJobs((ListEarthObservationJobsRequest)((Object)((ListEarthObservationJobsRequest.Builder)ListEarthObservationJobsRequest.builder().applyMutation(listEarthObservationJobsRequest)).build()));
    }

    default public ListEarthObservationJobsIterable listEarthObservationJobsPaginator(ListEarthObservationJobsRequest listEarthObservationJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListEarthObservationJobsIterable listEarthObservationJobsPaginator(Consumer<ListEarthObservationJobsRequest.Builder> listEarthObservationJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listEarthObservationJobsPaginator((ListEarthObservationJobsRequest)((Object)((ListEarthObservationJobsRequest.Builder)ListEarthObservationJobsRequest.builder().applyMutation(listEarthObservationJobsRequest)).build()));
    }

    default public ListRasterDataCollectionsResponse listRasterDataCollections(ListRasterDataCollectionsRequest listRasterDataCollectionsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListRasterDataCollectionsResponse listRasterDataCollections(Consumer<ListRasterDataCollectionsRequest.Builder> listRasterDataCollectionsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listRasterDataCollections((ListRasterDataCollectionsRequest)((Object)((ListRasterDataCollectionsRequest.Builder)ListRasterDataCollectionsRequest.builder().applyMutation(listRasterDataCollectionsRequest)).build()));
    }

    default public ListRasterDataCollectionsIterable listRasterDataCollectionsPaginator(ListRasterDataCollectionsRequest listRasterDataCollectionsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListRasterDataCollectionsIterable listRasterDataCollectionsPaginator(Consumer<ListRasterDataCollectionsRequest.Builder> listRasterDataCollectionsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listRasterDataCollectionsPaginator((ListRasterDataCollectionsRequest)((Object)((ListRasterDataCollectionsRequest.Builder)ListRasterDataCollectionsRequest.builder().applyMutation(listRasterDataCollectionsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListVectorEnrichmentJobsResponse listVectorEnrichmentJobs(ListVectorEnrichmentJobsRequest listVectorEnrichmentJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListVectorEnrichmentJobsResponse listVectorEnrichmentJobs(Consumer<ListVectorEnrichmentJobsRequest.Builder> listVectorEnrichmentJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listVectorEnrichmentJobs((ListVectorEnrichmentJobsRequest)((Object)((ListVectorEnrichmentJobsRequest.Builder)ListVectorEnrichmentJobsRequest.builder().applyMutation(listVectorEnrichmentJobsRequest)).build()));
    }

    default public ListVectorEnrichmentJobsIterable listVectorEnrichmentJobsPaginator(ListVectorEnrichmentJobsRequest listVectorEnrichmentJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public ListVectorEnrichmentJobsIterable listVectorEnrichmentJobsPaginator(Consumer<ListVectorEnrichmentJobsRequest.Builder> listVectorEnrichmentJobsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.listVectorEnrichmentJobsPaginator((ListVectorEnrichmentJobsRequest)((Object)((ListVectorEnrichmentJobsRequest.Builder)ListVectorEnrichmentJobsRequest.builder().applyMutation(listVectorEnrichmentJobsRequest)).build()));
    }

    default public SearchRasterDataCollectionResponse searchRasterDataCollection(SearchRasterDataCollectionRequest searchRasterDataCollectionRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public SearchRasterDataCollectionResponse searchRasterDataCollection(Consumer<SearchRasterDataCollectionRequest.Builder> searchRasterDataCollectionRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.searchRasterDataCollection((SearchRasterDataCollectionRequest)((Object)((SearchRasterDataCollectionRequest.Builder)SearchRasterDataCollectionRequest.builder().applyMutation(searchRasterDataCollectionRequest)).build()));
    }

    default public SearchRasterDataCollectionIterable searchRasterDataCollectionPaginator(SearchRasterDataCollectionRequest searchRasterDataCollectionRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public SearchRasterDataCollectionIterable searchRasterDataCollectionPaginator(Consumer<SearchRasterDataCollectionRequest.Builder> searchRasterDataCollectionRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.searchRasterDataCollectionPaginator((SearchRasterDataCollectionRequest)((Object)((SearchRasterDataCollectionRequest.Builder)SearchRasterDataCollectionRequest.builder().applyMutation(searchRasterDataCollectionRequest)).build()));
    }

    default public StartEarthObservationJobResponse startEarthObservationJob(StartEarthObservationJobRequest startEarthObservationJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public StartEarthObservationJobResponse startEarthObservationJob(Consumer<StartEarthObservationJobRequest.Builder> startEarthObservationJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.startEarthObservationJob((StartEarthObservationJobRequest)((Object)((StartEarthObservationJobRequest.Builder)StartEarthObservationJobRequest.builder().applyMutation(startEarthObservationJobRequest)).build()));
    }

    default public StartVectorEnrichmentJobResponse startVectorEnrichmentJob(StartVectorEnrichmentJobRequest startVectorEnrichmentJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public StartVectorEnrichmentJobResponse startVectorEnrichmentJob(Consumer<StartVectorEnrichmentJobRequest.Builder> startVectorEnrichmentJobRequest) throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.startVectorEnrichmentJob((StartVectorEnrichmentJobRequest)((Object)((StartVectorEnrichmentJobRequest.Builder)StartVectorEnrichmentJobRequest.builder().applyMutation(startVectorEnrichmentJobRequest)).build()));
    }

    default public StopEarthObservationJobResponse stopEarthObservationJob(StopEarthObservationJobRequest stopEarthObservationJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public StopEarthObservationJobResponse stopEarthObservationJob(Consumer<StopEarthObservationJobRequest.Builder> stopEarthObservationJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.stopEarthObservationJob((StopEarthObservationJobRequest)((Object)((StopEarthObservationJobRequest.Builder)StopEarthObservationJobRequest.builder().applyMutation(stopEarthObservationJobRequest)).build()));
    }

    default public StopVectorEnrichmentJobResponse stopVectorEnrichmentJob(StopVectorEnrichmentJobRequest stopVectorEnrichmentJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public StopVectorEnrichmentJobResponse stopVectorEnrichmentJob(Consumer<StopVectorEnrichmentJobRequest.Builder> stopVectorEnrichmentJobRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.stopVectorEnrichmentJob((StopVectorEnrichmentJobRequest)((Object)((StopVectorEnrichmentJobRequest.Builder)StopVectorEnrichmentJobRequest.builder().applyMutation(stopVectorEnrichmentJobRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerGeospatialException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"sagemaker-geospatial");
    }
}

