/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.RecordCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecordResponse
extends SageMakerFeatureStoreRuntimeResponse
implements ToCopyableBuilder<Builder, GetRecordResponse> {
    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Record").getter(GetRecordResponse.getter(GetRecordResponse::record)).setter(GetRecordResponse.setter(Builder::record)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpiresAt").getter(GetRecordResponse.getter(GetRecordResponse::expiresAt)).setter(GetRecordResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FIELD, EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecordResponse.memberNameToFieldInitializer();
    private final List<FeatureValue> record;
    private final String expiresAt;

    private GetRecordResponse(BuilderImpl builder) {
        super(builder);
        this.record = builder.record;
        this.expiresAt = builder.expiresAt;
    }

    public final boolean hasRecord() {
        return this.record != null && !(this.record instanceof SdkAutoConstructList);
    }

    public final List<FeatureValue> record() {
        return this.record;
    }

    public final String expiresAt() {
        return this.expiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecord() ? this.record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordResponse)) {
            return false;
        }
        GetRecordResponse other = (GetRecordResponse)((Object)obj);
        return this.hasRecord() == other.hasRecord() && Objects.equals(this.record(), other.record()) && Objects.equals(this.expiresAt(), other.expiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecordResponse").add("Record", this.hasRecord() ? this.record() : null).add("ExpiresAt", (Object)this.expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Record", RECORD_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecordResponse, T> g) {
        return obj -> g.apply((GetRecordResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeResponse.BuilderImpl
    implements Builder {
        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();
        private String expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordResponse model) {
            super(model);
            this.record(model.record);
            this.expiresAt(model.expiresAt);
        }

        public final List<FeatureValue.Builder> getRecord() {
            List<FeatureValue.Builder> result = RecordCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(FeatureValue ... record) {
            this.record(Arrays.asList(record));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder> ... record) {
            this.record(Stream.of(record).map(c -> (FeatureValue)((FeatureValue.Builder)FeatureValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public GetRecordResponse build() {
            return new GetRecordResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerFeatureStoreRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecordResponse> {
        public Builder record(Collection<FeatureValue> var1);

        public Builder record(FeatureValue ... var1);

        public Builder record(Consumer<FeatureValue.Builder> ... var1);

        public Builder expiresAt(String var1);
    }
}

