/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.RecordCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStoresCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TtlDuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordRequest
extends SageMakerFeatureStoreRuntimeRequest
implements ToCopyableBuilder<Builder, PutRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(PutRecordRequest.getter(PutRecordRequest::featureGroupName)).setter(PutRecordRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Record").getter(PutRecordRequest.getter(PutRecordRequest::record)).setter(PutRecordRequest.setter(Builder::record)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetStores").getter(PutRecordRequest.getter(PutRecordRequest::targetStoresAsStrings)).setter(PutRecordRequest.setter(Builder::targetStoresWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TtlDuration> TTL_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TtlDuration").getter(PutRecordRequest.getter(PutRecordRequest::ttlDuration)).setter(PutRecordRequest.setter(Builder::ttlDuration)).constructor(TtlDuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TtlDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, RECORD_FIELD, TARGET_STORES_FIELD, TTL_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRecordRequest.memberNameToFieldInitializer();
    private final String featureGroupName;
    private final List<FeatureValue> record;
    private final List<String> targetStores;
    private final TtlDuration ttlDuration;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.record = builder.record;
        this.targetStores = builder.targetStores;
        this.ttlDuration = builder.ttlDuration;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final boolean hasRecord() {
        return this.record != null && !(this.record instanceof SdkAutoConstructList);
    }

    public final List<FeatureValue> record() {
        return this.record;
    }

    public final List<TargetStore> targetStores() {
        return TargetStoresCopier.copyStringToEnum(this.targetStores);
    }

    public final boolean hasTargetStores() {
        return this.targetStores != null && !(this.targetStores instanceof SdkAutoConstructList);
    }

    public final List<String> targetStoresAsStrings() {
        return this.targetStores;
    }

    public final TtlDuration ttlDuration() {
        return this.ttlDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecord() ? this.record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetStores() ? this.targetStoresAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ttlDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && this.hasRecord() == other.hasRecord() && Objects.equals(this.record(), other.record()) && this.hasTargetStores() == other.hasTargetStores() && Objects.equals(this.targetStoresAsStrings(), other.targetStoresAsStrings()) && Objects.equals(this.ttlDuration(), other.ttlDuration());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecordRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("Record", this.hasRecord() ? this.record() : null).add("TargetStores", this.hasTargetStores() ? this.targetStoresAsStrings() : null).add("TtlDuration", (Object)this.ttlDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "Record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
            case "TargetStores": {
                return Optional.ofNullable(clazz.cast(this.targetStoresAsStrings()));
            }
            case "TtlDuration": {
                return Optional.ofNullable(clazz.cast(this.ttlDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("Record", RECORD_FIELD);
        map.put("TargetStores", TARGET_STORES_FIELD);
        map.put("TtlDuration", TTL_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRecordRequest, T> g) {
        return obj -> g.apply((PutRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetStores = DefaultSdkAutoConstructList.getInstance();
        private TtlDuration ttlDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.record(model.record);
            this.targetStoresWithStrings(model.targetStores);
            this.ttlDuration(model.ttlDuration);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final List<FeatureValue.Builder> getRecord() {
            List<FeatureValue.Builder> result = RecordCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(FeatureValue ... record) {
            this.record(Arrays.asList(record));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder> ... record) {
            this.record(Stream.of(record).map(c -> (FeatureValue)((FeatureValue.Builder)FeatureValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTargetStores() {
            if (this.targetStores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetStores;
        }

        public final void setTargetStores(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
        }

        @Override
        public final Builder targetStoresWithStrings(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStoresWithStrings(String ... targetStores) {
            this.targetStoresWithStrings(Arrays.asList(targetStores));
            return this;
        }

        @Override
        public final Builder targetStores(Collection<TargetStore> targetStores) {
            this.targetStores = TargetStoresCopier.copyEnumToString(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStores(TargetStore ... targetStores) {
            this.targetStores(Arrays.asList(targetStores));
            return this;
        }

        public final TtlDuration.Builder getTtlDuration() {
            return this.ttlDuration != null ? this.ttlDuration.toBuilder() : null;
        }

        public final void setTtlDuration(TtlDuration.BuilderImpl ttlDuration) {
            this.ttlDuration = ttlDuration != null ? ttlDuration.build() : null;
        }

        @Override
        public final Builder ttlDuration(TtlDuration ttlDuration) {
            this.ttlDuration = ttlDuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerFeatureStoreRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordRequest> {
        public Builder featureGroupName(String var1);

        public Builder record(Collection<FeatureValue> var1);

        public Builder record(FeatureValue ... var1);

        public Builder record(Consumer<FeatureValue.Builder> ... var1);

        public Builder targetStoresWithStrings(Collection<String> var1);

        public Builder targetStoresWithStrings(String ... var1);

        public Builder targetStores(Collection<TargetStore> var1);

        public Builder targetStores(TargetStore ... var1);

        public Builder ttlDuration(TtlDuration var1);

        default public Builder ttlDuration(Consumer<TtlDuration.Builder> ttlDuration) {
            return this.ttlDuration((TtlDuration)((TtlDuration.Builder)TtlDuration.builder().applyMutation(ttlDuration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

