/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.RecordCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordRequest
extends SageMakerFeatureStoreRuntimeRequest
implements ToCopyableBuilder<Builder, PutRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(PutRecordRequest.getter(PutRecordRequest::featureGroupName)).setter(PutRecordRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Record").getter(PutRecordRequest.getter(PutRecordRequest::record)).setter(PutRecordRequest.setter(Builder::record)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, RECORD_FIELD));
    private final String featureGroupName;
    private final List<FeatureValue> record;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.record = builder.record;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final boolean hasRecord() {
        return this.record != null && !(this.record instanceof SdkAutoConstructList);
    }

    public final List<FeatureValue> record() {
        return this.record;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecord() ? this.record() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && this.hasRecord() == other.hasRecord() && Objects.equals(this.record(), other.record());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecordRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("Record", this.hasRecord() ? this.record() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "Record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordRequest, T> g) {
        return obj -> g.apply((PutRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.record(model.record);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final List<FeatureValue.Builder> getRecord() {
            List<FeatureValue.Builder> result = RecordCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(FeatureValue ... record) {
            this.record(Arrays.asList(record));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder> ... record) {
            this.record(Stream.of(record).map(c -> (FeatureValue)((FeatureValue.Builder)FeatureValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerFeatureStoreRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordRequest> {
        public Builder featureGroupName(String var1);

        public Builder record(Collection<FeatureValue> var1);

        public Builder record(FeatureValue ... var1);

        public Builder record(Consumer<FeatureValue.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

