/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureNamesCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.RecordIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRecordIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetRecordIdentifier> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(BatchGetRecordIdentifier.getter(BatchGetRecordIdentifier::featureGroupName)).setter(BatchGetRecordIdentifier.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<List<String>> RECORD_IDENTIFIERS_VALUE_AS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordIdentifiersValueAsString").getter(BatchGetRecordIdentifier.getter(BatchGetRecordIdentifier::recordIdentifiersValueAsString)).setter(BatchGetRecordIdentifier.setter(Builder::recordIdentifiersValueAsString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifiersValueAsString").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FEATURE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureNames").getter(BatchGetRecordIdentifier.getter(BatchGetRecordIdentifier::featureNames)).setter(BatchGetRecordIdentifier.setter(Builder::featureNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIERS_VALUE_AS_STRING_FIELD, FEATURE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featureGroupName;
    private final List<String> recordIdentifiersValueAsString;
    private final List<String> featureNames;

    private BatchGetRecordIdentifier(BuilderImpl builder) {
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifiersValueAsString = builder.recordIdentifiersValueAsString;
        this.featureNames = builder.featureNames;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final boolean hasRecordIdentifiersValueAsString() {
        return this.recordIdentifiersValueAsString != null && !(this.recordIdentifiersValueAsString instanceof SdkAutoConstructList);
    }

    public final List<String> recordIdentifiersValueAsString() {
        return this.recordIdentifiersValueAsString;
    }

    public final boolean hasFeatureNames() {
        return this.featureNames != null && !(this.featureNames instanceof SdkAutoConstructList);
    }

    public final List<String> featureNames() {
        return this.featureNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordIdentifiersValueAsString() ? this.recordIdentifiersValueAsString() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureNames() ? this.featureNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordIdentifier)) {
            return false;
        }
        BatchGetRecordIdentifier other = (BatchGetRecordIdentifier)obj;
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && this.hasRecordIdentifiersValueAsString() == other.hasRecordIdentifiersValueAsString() && Objects.equals(this.recordIdentifiersValueAsString(), other.recordIdentifiersValueAsString()) && this.hasFeatureNames() == other.hasFeatureNames() && Objects.equals(this.featureNames(), other.featureNames());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRecordIdentifier").add("FeatureGroupName", (Object)this.featureGroupName()).add("RecordIdentifiersValueAsString", this.hasRecordIdentifiersValueAsString() ? this.recordIdentifiersValueAsString() : null).add("FeatureNames", this.hasFeatureNames() ? this.featureNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "RecordIdentifiersValueAsString": {
                return Optional.ofNullable(clazz.cast(this.recordIdentifiersValueAsString()));
            }
            case "FeatureNames": {
                return Optional.ofNullable(clazz.cast(this.featureNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordIdentifier, T> g) {
        return obj -> g.apply((BatchGetRecordIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureGroupName;
        private List<String> recordIdentifiersValueAsString = DefaultSdkAutoConstructList.getInstance();
        private List<String> featureNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordIdentifier model) {
            this.featureGroupName(model.featureGroupName);
            this.recordIdentifiersValueAsString(model.recordIdentifiersValueAsString);
            this.featureNames(model.featureNames);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        public final Collection<String> getRecordIdentifiersValueAsString() {
            if (this.recordIdentifiersValueAsString instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordIdentifiersValueAsString;
        }

        @Override
        public final Builder recordIdentifiersValueAsString(Collection<String> recordIdentifiersValueAsString) {
            this.recordIdentifiersValueAsString = RecordIdentifiersCopier.copy(recordIdentifiersValueAsString);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordIdentifiersValueAsString(String ... recordIdentifiersValueAsString) {
            this.recordIdentifiersValueAsString(Arrays.asList(recordIdentifiersValueAsString));
            return this;
        }

        public final void setRecordIdentifiersValueAsString(Collection<String> recordIdentifiersValueAsString) {
            this.recordIdentifiersValueAsString = RecordIdentifiersCopier.copy(recordIdentifiersValueAsString);
        }

        public final Collection<String> getFeatureNames() {
            if (this.featureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureNames;
        }

        @Override
        public final Builder featureNames(Collection<String> featureNames) {
            this.featureNames = FeatureNamesCopier.copy(featureNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureNames(String ... featureNames) {
            this.featureNames(Arrays.asList(featureNames));
            return this;
        }

        public final void setFeatureNames(Collection<String> featureNames) {
            this.featureNames = FeatureNamesCopier.copy(featureNames);
        }

        public BatchGetRecordIdentifier build() {
            return new BatchGetRecordIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetRecordIdentifier> {
        public Builder featureGroupName(String var1);

        public Builder recordIdentifiersValueAsString(Collection<String> var1);

        public Builder recordIdentifiersValueAsString(String ... var1);

        public Builder featureNames(Collection<String> var1);

        public Builder featureNames(String ... var1);
    }
}

