/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemakeredge.DefaultSagemakerEdgeClientBuilder;
import software.amazon.awssdk.services.sagemakeredge.SagemakerEdgeClientBuilder;
import software.amazon.awssdk.services.sagemakeredge.SagemakerEdgeServiceClientConfiguration;
import software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationRequest;
import software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse;
import software.amazon.awssdk.services.sagemakeredge.model.InternalServiceException;
import software.amazon.awssdk.services.sagemakeredge.model.SagemakerEdgeException;
import software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest;
import software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatResponse;

@SdkPublicApi
@ThreadSafe
public interface SagemakerEdgeClient
extends AwsClient {
    public static final String SERVICE_NAME = "sagemaker";
    public static final String SERVICE_METADATA_ID = "edge.sagemaker";

    default public GetDeploymentsResponse getDeployments(GetDeploymentsRequest getDeploymentsRequest) throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        throw new UnsupportedOperationException();
    }

    default public GetDeploymentsResponse getDeployments(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest) throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        return this.getDeployments((GetDeploymentsRequest)((Object)((GetDeploymentsRequest.Builder)GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest)).build()));
    }

    default public GetDeviceRegistrationResponse getDeviceRegistration(GetDeviceRegistrationRequest getDeviceRegistrationRequest) throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        throw new UnsupportedOperationException();
    }

    default public GetDeviceRegistrationResponse getDeviceRegistration(Consumer<GetDeviceRegistrationRequest.Builder> getDeviceRegistrationRequest) throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        return this.getDeviceRegistration((GetDeviceRegistrationRequest)((Object)((GetDeviceRegistrationRequest.Builder)GetDeviceRegistrationRequest.builder().applyMutation(getDeviceRegistrationRequest)).build()));
    }

    default public SendHeartbeatResponse sendHeartbeat(SendHeartbeatRequest sendHeartbeatRequest) throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        throw new UnsupportedOperationException();
    }

    default public SendHeartbeatResponse sendHeartbeat(Consumer<SendHeartbeatRequest.Builder> sendHeartbeatRequest) throws InternalServiceException, AwsServiceException, SdkClientException, SagemakerEdgeException {
        return this.sendHeartbeat((SendHeartbeatRequest)((Object)((SendHeartbeatRequest.Builder)SendHeartbeatRequest.builder().applyMutation(sendHeartbeatRequest)).build()));
    }

    public static SagemakerEdgeClient create() {
        return (SagemakerEdgeClient)SagemakerEdgeClient.builder().build();
    }

    public static SagemakerEdgeClientBuilder builder() {
        return new DefaultSagemakerEdgeClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    public SagemakerEdgeServiceClientConfiguration serviceClientConfiguration();
}

