/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric;
import software.amazon.awssdk.services.sagemakeredge.model.EdgeMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Model
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Model> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(Model.getter(Model::modelName)).setter(Model.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(Model.getter(Model::modelVersion)).setter(Model.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<Instant> LATEST_SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestSampleTime").getter(Model.getter(Model::latestSampleTime)).setter(Model.setter(Builder::latestSampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSampleTime").build()}).build();
    private static final SdkField<Instant> LATEST_INFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestInference").getter(Model.getter(Model::latestInference)).setter(Model.setter(Builder::latestInference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInference").build()}).build();
    private static final SdkField<List<EdgeMetric>> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelMetrics").getter(Model.getter(Model::modelMetrics)).setter(Model.setter(Builder::modelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_VERSION_FIELD, LATEST_SAMPLE_TIME_FIELD, LATEST_INFERENCE_FIELD, MODEL_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelVersion;
    private final Instant latestSampleTime;
    private final Instant latestInference;
    private final List<EdgeMetric> modelMetrics;

    private Model(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.latestSampleTime = builder.latestSampleTime;
        this.latestInference = builder.latestInference;
        this.modelMetrics = builder.modelMetrics;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final Instant latestSampleTime() {
        return this.latestSampleTime;
    }

    public final Instant latestInference() {
        return this.latestInference;
    }

    public final boolean hasModelMetrics() {
        return this.modelMetrics != null && !(this.modelMetrics instanceof SdkAutoConstructList);
    }

    public final List<EdgeMetric> modelMetrics() {
        return this.modelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestInference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelMetrics() ? this.modelMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model other = (Model)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.latestSampleTime(), other.latestSampleTime()) && Objects.equals(this.latestInference(), other.latestInference()) && this.hasModelMetrics() == other.hasModelMetrics() && Objects.equals(this.modelMetrics(), other.modelMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"Model").add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("LatestSampleTime", (Object)this.latestSampleTime()).add("LatestInference", (Object)this.latestInference()).add("ModelMetrics", this.hasModelMetrics() ? this.modelMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "LatestSampleTime": {
                return Optional.ofNullable(clazz.cast(this.latestSampleTime()));
            }
            case "LatestInference": {
                return Optional.ofNullable(clazz.cast(this.latestInference()));
            }
            case "ModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Model, T> g) {
        return obj -> g.apply((Model)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelVersion;
        private Instant latestSampleTime;
        private Instant latestInference;
        private List<EdgeMetric> modelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Model model) {
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.latestSampleTime(model.latestSampleTime);
            this.latestInference(model.latestInference);
            this.modelMetrics(model.modelMetrics);
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public final Instant getLatestSampleTime() {
            return this.latestSampleTime;
        }

        @Override
        public final Builder latestSampleTime(Instant latestSampleTime) {
            this.latestSampleTime = latestSampleTime;
            return this;
        }

        public final void setLatestSampleTime(Instant latestSampleTime) {
            this.latestSampleTime = latestSampleTime;
        }

        public final Instant getLatestInference() {
            return this.latestInference;
        }

        @Override
        public final Builder latestInference(Instant latestInference) {
            this.latestInference = latestInference;
            return this;
        }

        public final void setLatestInference(Instant latestInference) {
            this.latestInference = latestInference;
        }

        public final List<EdgeMetric.Builder> getModelMetrics() {
            List<EdgeMetric.Builder> result = EdgeMetricsCopier.copyToBuilder(this.modelMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder modelMetrics(Collection<EdgeMetric> modelMetrics) {
            this.modelMetrics = EdgeMetricsCopier.copy(modelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelMetrics(EdgeMetric ... modelMetrics) {
            this.modelMetrics(Arrays.asList(modelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelMetrics(Consumer<EdgeMetric.Builder> ... modelMetrics) {
            this.modelMetrics(Stream.of(modelMetrics).map(c -> (EdgeMetric)((EdgeMetric.Builder)EdgeMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelMetrics(Collection<EdgeMetric.BuilderImpl> modelMetrics) {
            this.modelMetrics = EdgeMetricsCopier.copyFromBuilder(modelMetrics);
        }

        public Model build() {
            return new Model(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Model> {
        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder latestSampleTime(Instant var1);

        public Builder latestInference(Instant var1);

        public Builder modelMetrics(Collection<EdgeMetric> var1);

        public Builder modelMetrics(EdgeMetric ... var1);

        public Builder modelMetrics(Consumer<EdgeMetric.Builder> ... var1);
    }
}

