/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantAcceleratorType;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariant> {
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductionVariant.getter(ProductionVariant::variantName)).setter(ProductionVariant.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductionVariant.getter(ProductionVariant::modelName)).setter(ProductionVariant.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Integer> INITIAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ProductionVariant.getter(ProductionVariant::initialInstanceCount)).setter(ProductionVariant.setter(Builder::initialInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialInstanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductionVariant.getter(ProductionVariant::instanceTypeAsString)).setter(ProductionVariant.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Float> INITIAL_VARIANT_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(ProductionVariant.getter(ProductionVariant::initialVariantWeight)).setter(ProductionVariant.setter(Builder::initialVariantWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialVariantWeight").build()}).build();
    private static final SdkField<String> ACCELERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductionVariant.getter(ProductionVariant::acceleratorTypeAsString)).setter(ProductionVariant.setter(Builder::acceleratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_NAME_FIELD, MODEL_NAME_FIELD, INITIAL_INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, INITIAL_VARIANT_WEIGHT_FIELD, ACCELERATOR_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String variantName;
    private final String modelName;
    private final Integer initialInstanceCount;
    private final String instanceType;
    private final Float initialVariantWeight;
    private final String acceleratorType;

    private ProductionVariant(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.modelName = builder.modelName;
        this.initialInstanceCount = builder.initialInstanceCount;
        this.instanceType = builder.instanceType;
        this.initialVariantWeight = builder.initialVariantWeight;
        this.acceleratorType = builder.acceleratorType;
    }

    public String variantName() {
        return this.variantName;
    }

    public String modelName() {
        return this.modelName;
    }

    public Integer initialInstanceCount() {
        return this.initialInstanceCount;
    }

    public ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Float initialVariantWeight() {
        return this.initialVariantWeight;
    }

    public ProductionVariantAcceleratorType acceleratorType() {
        return ProductionVariantAcceleratorType.fromValue(this.acceleratorType);
    }

    public String acceleratorTypeAsString() {
        return this.acceleratorType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVariantWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariant)) {
            return false;
        }
        ProductionVariant other = (ProductionVariant)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.initialInstanceCount(), other.initialInstanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.initialVariantWeight(), other.initialVariantWeight()) && Objects.equals(this.acceleratorTypeAsString(), other.acceleratorTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProductionVariant").add("VariantName", (Object)this.variantName()).add("ModelName", (Object)this.modelName()).add("InitialInstanceCount", (Object)this.initialInstanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("InitialVariantWeight", (Object)this.initialVariantWeight()).add("AcceleratorType", (Object)this.acceleratorTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "InitialInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.initialInstanceCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InitialVariantWeight": {
                return Optional.ofNullable(clazz.cast(this.initialVariantWeight()));
            }
            case "AcceleratorType": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariant, T> g) {
        return obj -> g.apply((ProductionVariant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private String modelName;
        private Integer initialInstanceCount;
        private String instanceType;
        private Float initialVariantWeight;
        private String acceleratorType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariant model) {
            this.variantName(model.variantName);
            this.modelName(model.modelName);
            this.initialInstanceCount(model.initialInstanceCount);
            this.instanceType(model.instanceType);
            this.initialVariantWeight(model.initialVariantWeight);
            this.acceleratorType(model.acceleratorType);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getInitialInstanceCount() {
            return this.initialInstanceCount;
        }

        @Override
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        public final String getInstanceTypeAsString() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Float getInitialVariantWeight() {
            return this.initialVariantWeight;
        }

        @Override
        public final Builder initialVariantWeight(Float initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
            return this;
        }

        public final void setInitialVariantWeight(Float initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
        }

        public final String getAcceleratorTypeAsString() {
            return this.acceleratorType;
        }

        @Override
        public final Builder acceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        @Override
        public final Builder acceleratorType(ProductionVariantAcceleratorType acceleratorType) {
            this.acceleratorType(acceleratorType.toString());
            return this;
        }

        public final void setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
        }

        public ProductionVariant build() {
            return new ProductionVariant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariant> {
        public Builder variantName(String var1);

        public Builder modelName(String var1);

        public Builder initialInstanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ProductionVariantInstanceType var1);

        public Builder initialVariantWeight(Float var1);

        public Builder acceleratorType(String var1);

        public Builder acceleratorType(ProductionVariantAcceleratorType var1);
    }
}

