/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.TrainingInputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingJobDefinition> {
    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJobDefinition.getter(TrainingJobDefinition::trainingInputModeAsString)).setter(TrainingJobDefinition.setter(Builder::trainingInputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingInputMode").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TrainingJobDefinition.getter(TrainingJobDefinition::hyperParameters)).setter(TrainingJobDefinition.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJobDefinition.getter(TrainingJobDefinition::inputDataConfig)).setter(TrainingJobDefinition.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJobDefinition.getter(TrainingJobDefinition::outputDataConfig)).setter(TrainingJobDefinition.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJobDefinition.getter(TrainingJobDefinition::resourceConfig)).setter(TrainingJobDefinition.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJobDefinition.getter(TrainingJobDefinition::stoppingCondition)).setter(TrainingJobDefinition.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_INPUT_MODE_FIELD, HYPER_PARAMETERS_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, STOPPING_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingInputMode;
    private final Map<String, String> hyperParameters;
    private final List<Channel> inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final StoppingCondition stoppingCondition;

    private TrainingJobDefinition(BuilderImpl builder) {
        this.trainingInputMode = builder.trainingInputMode;
        this.hyperParameters = builder.hyperParameters;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
    }

    public TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(this.trainingInputMode);
    }

    public String trainingInputModeAsString() {
        return this.trainingInputMode;
    }

    public Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobDefinition)) {
            return false;
        }
        TrainingJobDefinition other = (TrainingJobDefinition)obj;
        return Objects.equals(this.trainingInputModeAsString(), other.trainingInputModeAsString()) && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition());
    }

    public String toString() {
        return ToString.builder((String)"TrainingJobDefinition").add("TrainingInputMode", (Object)this.trainingInputModeAsString()).add("HyperParameters", this.hyperParameters()).add("InputDataConfig", this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingInputMode": {
                return Optional.ofNullable(clazz.cast(this.trainingInputModeAsString()));
            }
            case "HyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingJobDefinition, T> g) {
        return obj -> g.apply((TrainingJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingInputMode;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private StoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobDefinition model) {
            this.trainingInputMode(model.trainingInputMode);
            this.hyperParameters(model.hyperParameters);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.stoppingCondition(model.stoppingCondition);
        }

        public final String getTrainingInputModeAsString() {
            return this.trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode.toString());
            return this;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        public final Map<String, String> getHyperParameters() {
            return this.hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public TrainingJobDefinition build() {
            return new TrainingJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingJobDefinition> {
        public Builder trainingInputMode(String var1);

        public Builder trainingInputMode(TrainingInputMode var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }
    }
}

