/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartType;
import software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJob;
import software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJobsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningJobWarmStartConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTuningJobWarmStartConfig> {
    private static final SdkField<List<ParentHyperParameterTuningJob>> PARENT_HYPER_PARAMETER_TUNING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HyperParameterTuningJobWarmStartConfig.getter(HyperParameterTuningJobWarmStartConfig::parentHyperParameterTuningJobs)).setter(HyperParameterTuningJobWarmStartConfig.setter(Builder::parentHyperParameterTuningJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentHyperParameterTuningJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParentHyperParameterTuningJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WARM_START_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterTuningJobWarmStartConfig.getter(HyperParameterTuningJobWarmStartConfig::warmStartTypeAsString)).setter(HyperParameterTuningJobWarmStartConfig.setter(Builder::warmStartType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmStartType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_HYPER_PARAMETER_TUNING_JOBS_FIELD, WARM_START_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ParentHyperParameterTuningJob> parentHyperParameterTuningJobs;
    private final String warmStartType;

    private HyperParameterTuningJobWarmStartConfig(BuilderImpl builder) {
        this.parentHyperParameterTuningJobs = builder.parentHyperParameterTuningJobs;
        this.warmStartType = builder.warmStartType;
    }

    public List<ParentHyperParameterTuningJob> parentHyperParameterTuningJobs() {
        return this.parentHyperParameterTuningJobs;
    }

    public HyperParameterTuningJobWarmStartType warmStartType() {
        return HyperParameterTuningJobWarmStartType.fromValue(this.warmStartType);
    }

    public String warmStartTypeAsString() {
        return this.warmStartType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentHyperParameterTuningJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmStartTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobWarmStartConfig)) {
            return false;
        }
        HyperParameterTuningJobWarmStartConfig other = (HyperParameterTuningJobWarmStartConfig)obj;
        return Objects.equals(this.parentHyperParameterTuningJobs(), other.parentHyperParameterTuningJobs()) && Objects.equals(this.warmStartTypeAsString(), other.warmStartTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTuningJobWarmStartConfig").add("ParentHyperParameterTuningJobs", this.parentHyperParameterTuningJobs()).add("WarmStartType", (Object)this.warmStartTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentHyperParameterTuningJobs": {
                return Optional.ofNullable(clazz.cast(this.parentHyperParameterTuningJobs()));
            }
            case "WarmStartType": {
                return Optional.ofNullable(clazz.cast(this.warmStartTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobWarmStartConfig, T> g) {
        return obj -> g.apply((HyperParameterTuningJobWarmStartConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ParentHyperParameterTuningJob> parentHyperParameterTuningJobs = DefaultSdkAutoConstructList.getInstance();
        private String warmStartType;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobWarmStartConfig model) {
            this.parentHyperParameterTuningJobs(model.parentHyperParameterTuningJobs);
            this.warmStartType(model.warmStartType);
        }

        public final Collection<ParentHyperParameterTuningJob.Builder> getParentHyperParameterTuningJobs() {
            return this.parentHyperParameterTuningJobs != null ? (Collection)this.parentHyperParameterTuningJobs.stream().map(ParentHyperParameterTuningJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parentHyperParameterTuningJobs(Collection<ParentHyperParameterTuningJob> parentHyperParameterTuningJobs) {
            this.parentHyperParameterTuningJobs = ParentHyperParameterTuningJobsCopier.copy(parentHyperParameterTuningJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentHyperParameterTuningJobs(ParentHyperParameterTuningJob ... parentHyperParameterTuningJobs) {
            this.parentHyperParameterTuningJobs(Arrays.asList(parentHyperParameterTuningJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentHyperParameterTuningJobs(Consumer<ParentHyperParameterTuningJob.Builder> ... parentHyperParameterTuningJobs) {
            this.parentHyperParameterTuningJobs(Stream.of(parentHyperParameterTuningJobs).map(c -> (ParentHyperParameterTuningJob)((ParentHyperParameterTuningJob.Builder)ParentHyperParameterTuningJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParentHyperParameterTuningJobs(Collection<ParentHyperParameterTuningJob.BuilderImpl> parentHyperParameterTuningJobs) {
            this.parentHyperParameterTuningJobs = ParentHyperParameterTuningJobsCopier.copyFromBuilder(parentHyperParameterTuningJobs);
        }

        public final String getWarmStartTypeAsString() {
            return this.warmStartType;
        }

        @Override
        public final Builder warmStartType(String warmStartType) {
            this.warmStartType = warmStartType;
            return this;
        }

        @Override
        public final Builder warmStartType(HyperParameterTuningJobWarmStartType warmStartType) {
            this.warmStartType(warmStartType.toString());
            return this;
        }

        public final void setWarmStartType(String warmStartType) {
            this.warmStartType = warmStartType;
        }

        public HyperParameterTuningJobWarmStartConfig build() {
            return new HyperParameterTuningJobWarmStartConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTuningJobWarmStartConfig> {
        public Builder parentHyperParameterTuningJobs(Collection<ParentHyperParameterTuningJob> var1);

        public Builder parentHyperParameterTuningJobs(ParentHyperParameterTuningJob ... var1);

        public Builder parentHyperParameterTuningJobs(Consumer<ParentHyperParameterTuningJob.Builder> ... var1);

        public Builder warmStartType(String var1);

        public Builder warmStartType(HyperParameterTuningJobWarmStartType var1);
    }
}

