/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjective;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType;
import software.amazon.awssdk.services.sagemaker.model.ParameterRanges;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimits;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTuningJobConfig> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::strategyAsString)).setter(HyperParameterTuningJobConfig.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final SdkField<HyperParameterTuningJobObjective> HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::hyperParameterTuningJobObjective)).setter(HyperParameterTuningJobConfig.setter(Builder::hyperParameterTuningJobObjective)).constructor(HyperParameterTuningJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobObjective").build()}).build();
    private static final SdkField<ResourceLimits> RESOURCE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::resourceLimits)).setter(HyperParameterTuningJobConfig.setter(Builder::resourceLimits)).constructor(ResourceLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLimits").build()}).build();
    private static final SdkField<ParameterRanges> PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::parameterRanges)).setter(HyperParameterTuningJobConfig.setter(Builder::parameterRanges)).constructor(ParameterRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterRanges").build()}).build();
    private static final SdkField<String> TRAINING_JOB_EARLY_STOPPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::trainingJobEarlyStoppingTypeAsString)).setter(HyperParameterTuningJobConfig.setter(Builder::trainingJobEarlyStoppingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobEarlyStoppingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD, HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_FIELD, RESOURCE_LIMITS_FIELD, PARAMETER_RANGES_FIELD, TRAINING_JOB_EARLY_STOPPING_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String strategy;
    private final HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
    private final ResourceLimits resourceLimits;
    private final ParameterRanges parameterRanges;
    private final String trainingJobEarlyStoppingType;

    private HyperParameterTuningJobConfig(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.hyperParameterTuningJobObjective = builder.hyperParameterTuningJobObjective;
        this.resourceLimits = builder.resourceLimits;
        this.parameterRanges = builder.parameterRanges;
        this.trainingJobEarlyStoppingType = builder.trainingJobEarlyStoppingType;
    }

    public HyperParameterTuningJobStrategyType strategy() {
        return HyperParameterTuningJobStrategyType.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    public HyperParameterTuningJobObjective hyperParameterTuningJobObjective() {
        return this.hyperParameterTuningJobObjective;
    }

    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    public ParameterRanges parameterRanges() {
        return this.parameterRanges;
    }

    public TrainingJobEarlyStoppingType trainingJobEarlyStoppingType() {
        return TrainingJobEarlyStoppingType.fromValue(this.trainingJobEarlyStoppingType);
    }

    public String trainingJobEarlyStoppingTypeAsString() {
        return this.trainingJobEarlyStoppingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobEarlyStoppingTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobConfig)) {
            return false;
        }
        HyperParameterTuningJobConfig other = (HyperParameterTuningJobConfig)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.hyperParameterTuningJobObjective(), other.hyperParameterTuningJobObjective()) && Objects.equals(this.resourceLimits(), other.resourceLimits()) && Objects.equals(this.parameterRanges(), other.parameterRanges()) && Objects.equals(this.trainingJobEarlyStoppingTypeAsString(), other.trainingJobEarlyStoppingTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTuningJobConfig").add("Strategy", (Object)this.strategyAsString()).add("HyperParameterTuningJobObjective", (Object)this.hyperParameterTuningJobObjective()).add("ResourceLimits", (Object)this.resourceLimits()).add("ParameterRanges", (Object)this.parameterRanges()).add("TrainingJobEarlyStoppingType", (Object)this.trainingJobEarlyStoppingTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "HyperParameterTuningJobObjective": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobObjective()));
            }
            case "ResourceLimits": {
                return Optional.ofNullable(clazz.cast(this.resourceLimits()));
            }
            case "ParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.parameterRanges()));
            }
            case "TrainingJobEarlyStoppingType": {
                return Optional.ofNullable(clazz.cast(this.trainingJobEarlyStoppingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobConfig, T> g) {
        return obj -> g.apply((HyperParameterTuningJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
        private ResourceLimits resourceLimits;
        private ParameterRanges parameterRanges;
        private String trainingJobEarlyStoppingType;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobConfig model) {
            this.strategy(model.strategy);
            this.hyperParameterTuningJobObjective(model.hyperParameterTuningJobObjective);
            this.resourceLimits(model.resourceLimits);
            this.parameterRanges(model.parameterRanges);
            this.trainingJobEarlyStoppingType(model.trainingJobEarlyStoppingType);
        }

        public final String getStrategyAsString() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(HyperParameterTuningJobStrategyType strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final HyperParameterTuningJobObjective.Builder getHyperParameterTuningJobObjective() {
            return this.hyperParameterTuningJobObjective != null ? this.hyperParameterTuningJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobObjective(HyperParameterTuningJobObjective hyperParameterTuningJobObjective) {
            this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective;
            return this;
        }

        public final void setHyperParameterTuningJobObjective(HyperParameterTuningJobObjective.BuilderImpl hyperParameterTuningJobObjective) {
            this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective != null ? hyperParameterTuningJobObjective.build() : null;
        }

        public final ResourceLimits.Builder getResourceLimits() {
            return this.resourceLimits != null ? this.resourceLimits.toBuilder() : null;
        }

        @Override
        public final Builder resourceLimits(ResourceLimits resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        public final void setResourceLimits(ResourceLimits.BuilderImpl resourceLimits) {
            this.resourceLimits = resourceLimits != null ? resourceLimits.build() : null;
        }

        public final ParameterRanges.Builder getParameterRanges() {
            return this.parameterRanges != null ? this.parameterRanges.toBuilder() : null;
        }

        @Override
        public final Builder parameterRanges(ParameterRanges parameterRanges) {
            this.parameterRanges = parameterRanges;
            return this;
        }

        public final void setParameterRanges(ParameterRanges.BuilderImpl parameterRanges) {
            this.parameterRanges = parameterRanges != null ? parameterRanges.build() : null;
        }

        public final String getTrainingJobEarlyStoppingTypeAsString() {
            return this.trainingJobEarlyStoppingType;
        }

        @Override
        public final Builder trainingJobEarlyStoppingType(String trainingJobEarlyStoppingType) {
            this.trainingJobEarlyStoppingType = trainingJobEarlyStoppingType;
            return this;
        }

        @Override
        public final Builder trainingJobEarlyStoppingType(TrainingJobEarlyStoppingType trainingJobEarlyStoppingType) {
            this.trainingJobEarlyStoppingType(trainingJobEarlyStoppingType == null ? null : trainingJobEarlyStoppingType.toString());
            return this;
        }

        public final void setTrainingJobEarlyStoppingType(String trainingJobEarlyStoppingType) {
            this.trainingJobEarlyStoppingType = trainingJobEarlyStoppingType;
        }

        public HyperParameterTuningJobConfig build() {
            return new HyperParameterTuningJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTuningJobConfig> {
        public Builder strategy(String var1);

        public Builder strategy(HyperParameterTuningJobStrategyType var1);

        public Builder hyperParameterTuningJobObjective(HyperParameterTuningJobObjective var1);

        default public Builder hyperParameterTuningJobObjective(Consumer<HyperParameterTuningJobObjective.Builder> hyperParameterTuningJobObjective) {
            return this.hyperParameterTuningJobObjective((HyperParameterTuningJobObjective)((HyperParameterTuningJobObjective.Builder)HyperParameterTuningJobObjective.builder().applyMutation(hyperParameterTuningJobObjective)).build());
        }

        public Builder resourceLimits(ResourceLimits var1);

        default public Builder resourceLimits(Consumer<ResourceLimits.Builder> resourceLimits) {
            return this.resourceLimits((ResourceLimits)((ResourceLimits.Builder)ResourceLimits.builder().applyMutation(resourceLimits)).build());
        }

        public Builder parameterRanges(ParameterRanges var1);

        default public Builder parameterRanges(Consumer<ParameterRanges.Builder> parameterRanges) {
            return this.parameterRanges((ParameterRanges)((ParameterRanges.Builder)ParameterRanges.builder().applyMutation(parameterRanges)).build());
        }

        public Builder trainingJobEarlyStoppingType(String var1);

        public Builder trainingJobEarlyStoppingType(TrainingJobEarlyStoppingType var1);
    }
}

