/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TargetDevice {
    LAMBDA("lambda"),
    ML_M4("ml_m4"),
    ML_M5("ml_m5"),
    ML_C4("ml_c4"),
    ML_C5("ml_c5"),
    ML_P2("ml_p2"),
    ML_P3("ml_p3"),
    JETSON_TX1("jetson_tx1"),
    JETSON_TX2("jetson_tx2"),
    JETSON_NANO("jetson_nano"),
    RASP3_B("rasp3b"),
    DEEPLENS("deeplens"),
    RK3399("rk3399"),
    RK3288("rk3288"),
    SBE_C("sbe_c"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetDevice(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetDevice fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetDevice.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetDevice> knownValues() {
        return Stream.of(TargetDevice.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

