/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AdditionalCodeRepositoryNamesOrUrlsCopier;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.RootAccess;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotebookInstanceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateNotebookInstanceRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::notebookInstanceName)).setter(UpdateNotebookInstanceRequest.setter(Builder::notebookInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::instanceTypeAsString)).setter(UpdateNotebookInstanceRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::roleArn)).setter(UpdateNotebookInstanceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> LIFECYCLE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::lifecycleConfigName)).setter(UpdateNotebookInstanceRequest.setter(Builder::lifecycleConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigName").build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_LIFECYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::disassociateLifecycleConfig)).setter(UpdateNotebookInstanceRequest.setter(Builder::disassociateLifecycleConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateLifecycleConfig").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::volumeSizeInGB)).setter(UpdateNotebookInstanceRequest.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::defaultCodeRepository)).setter(UpdateNotebookInstanceRequest.setter(Builder::defaultCodeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::additionalCodeRepositories)).setter(UpdateNotebookInstanceRequest.setter(Builder::additionalCodeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::acceleratorTypesAsStrings)).setter(UpdateNotebookInstanceRequest.setter(Builder::acceleratorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::disassociateAcceleratorTypes)).setter(UpdateNotebookInstanceRequest.setter(Builder::disassociateAcceleratorTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateAcceleratorTypes").build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_DEFAULT_CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::disassociateDefaultCodeRepository)).setter(UpdateNotebookInstanceRequest.setter(Builder::disassociateDefaultCodeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateDefaultCodeRepository").build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::disassociateAdditionalCodeRepositories)).setter(UpdateNotebookInstanceRequest.setter(Builder::disassociateAdditionalCodeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateAdditionalCodeRepositories").build()}).build();
    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotebookInstanceRequest.getter(UpdateNotebookInstanceRequest::rootAccessAsString)).setter(UpdateNotebookInstanceRequest.setter(Builder::rootAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD, INSTANCE_TYPE_FIELD, ROLE_ARN_FIELD, LIFECYCLE_CONFIG_NAME_FIELD, DISASSOCIATE_LIFECYCLE_CONFIG_FIELD, VOLUME_SIZE_IN_GB_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ACCELERATOR_TYPES_FIELD, DISASSOCIATE_ACCELERATOR_TYPES_FIELD, DISASSOCIATE_DEFAULT_CODE_REPOSITORY_FIELD, DISASSOCIATE_ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD));
    private final String notebookInstanceName;
    private final String instanceType;
    private final String roleArn;
    private final String lifecycleConfigName;
    private final Boolean disassociateLifecycleConfig;
    private final Integer volumeSizeInGB;
    private final String defaultCodeRepository;
    private final List<String> additionalCodeRepositories;
    private final List<String> acceleratorTypes;
    private final Boolean disassociateAcceleratorTypes;
    private final Boolean disassociateDefaultCodeRepository;
    private final Boolean disassociateAdditionalCodeRepositories;
    private final String rootAccess;

    private UpdateNotebookInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.instanceType = builder.instanceType;
        this.roleArn = builder.roleArn;
        this.lifecycleConfigName = builder.lifecycleConfigName;
        this.disassociateLifecycleConfig = builder.disassociateLifecycleConfig;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.disassociateAcceleratorTypes = builder.disassociateAcceleratorTypes;
        this.disassociateDefaultCodeRepository = builder.disassociateDefaultCodeRepository;
        this.disassociateAdditionalCodeRepositories = builder.disassociateAdditionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
    }

    public String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String lifecycleConfigName() {
        return this.lifecycleConfigName;
    }

    public Boolean disassociateLifecycleConfig() {
        return this.disassociateLifecycleConfig;
    }

    public Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public String defaultCodeRepository() {
        return this.defaultCodeRepository;
    }

    public List<String> additionalCodeRepositories() {
        return this.additionalCodeRepositories;
    }

    public List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(this.acceleratorTypes);
    }

    public List<String> acceleratorTypesAsStrings() {
        return this.acceleratorTypes;
    }

    public Boolean disassociateAcceleratorTypes() {
        return this.disassociateAcceleratorTypes;
    }

    public Boolean disassociateDefaultCodeRepository() {
        return this.disassociateDefaultCodeRepository;
    }

    public Boolean disassociateAdditionalCodeRepositories() {
        return this.disassociateAdditionalCodeRepositories;
    }

    public RootAccess rootAccess() {
        return RootAccess.fromValue(this.rootAccess);
    }

    public String rootAccessAsString() {
        return this.rootAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateLifecycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalCodeRepositories());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateAcceleratorTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateDefaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateAdditionalCodeRepositories());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootAccessAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotebookInstanceRequest)) {
            return false;
        }
        UpdateNotebookInstanceRequest other = (UpdateNotebookInstanceRequest)((Object)obj);
        return Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.lifecycleConfigName(), other.lifecycleConfigName()) && Objects.equals(this.disassociateLifecycleConfig(), other.disassociateLifecycleConfig()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && Objects.equals(this.defaultCodeRepository(), other.defaultCodeRepository()) && Objects.equals(this.additionalCodeRepositories(), other.additionalCodeRepositories()) && Objects.equals(this.acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings()) && Objects.equals(this.disassociateAcceleratorTypes(), other.disassociateAcceleratorTypes()) && Objects.equals(this.disassociateDefaultCodeRepository(), other.disassociateDefaultCodeRepository()) && Objects.equals(this.disassociateAdditionalCodeRepositories(), other.disassociateAdditionalCodeRepositories()) && Objects.equals(this.rootAccessAsString(), other.rootAccessAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNotebookInstanceRequest").add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("LifecycleConfigName", (Object)this.lifecycleConfigName()).add("DisassociateLifecycleConfig", (Object)this.disassociateLifecycleConfig()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("DefaultCodeRepository", (Object)this.defaultCodeRepository()).add("AdditionalCodeRepositories", this.additionalCodeRepositories()).add("AcceleratorTypes", this.acceleratorTypesAsStrings()).add("DisassociateAcceleratorTypes", (Object)this.disassociateAcceleratorTypes()).add("DisassociateDefaultCodeRepository", (Object)this.disassociateDefaultCodeRepository()).add("DisassociateAdditionalCodeRepositories", (Object)this.disassociateAdditionalCodeRepositories()).add("RootAccess", (Object)this.rootAccessAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigName()));
            }
            case "DisassociateLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.disassociateLifecycleConfig()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "DefaultCodeRepository": {
                return Optional.ofNullable(clazz.cast(this.defaultCodeRepository()));
            }
            case "AdditionalCodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.additionalCodeRepositories()));
            }
            case "AcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypesAsStrings()));
            }
            case "DisassociateAcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.disassociateAcceleratorTypes()));
            }
            case "DisassociateDefaultCodeRepository": {
                return Optional.ofNullable(clazz.cast(this.disassociateDefaultCodeRepository()));
            }
            case "DisassociateAdditionalCodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.disassociateAdditionalCodeRepositories()));
            }
            case "RootAccess": {
                return Optional.ofNullable(clazz.cast(this.rootAccessAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotebookInstanceRequest, T> g) {
        return obj -> g.apply((UpdateNotebookInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String notebookInstanceName;
        private String instanceType;
        private String roleArn;
        private String lifecycleConfigName;
        private Boolean disassociateLifecycleConfig;
        private Integer volumeSizeInGB;
        private String defaultCodeRepository;
        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean disassociateAcceleratorTypes;
        private Boolean disassociateDefaultCodeRepository;
        private Boolean disassociateAdditionalCodeRepositories;
        private String rootAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotebookInstanceRequest model) {
            super(model);
            this.notebookInstanceName(model.notebookInstanceName);
            this.instanceType(model.instanceType);
            this.roleArn(model.roleArn);
            this.lifecycleConfigName(model.lifecycleConfigName);
            this.disassociateLifecycleConfig(model.disassociateLifecycleConfig);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.defaultCodeRepository(model.defaultCodeRepository);
            this.additionalCodeRepositories(model.additionalCodeRepositories);
            this.acceleratorTypesWithStrings(model.acceleratorTypes);
            this.disassociateAcceleratorTypes(model.disassociateAcceleratorTypes);
            this.disassociateDefaultCodeRepository(model.disassociateDefaultCodeRepository);
            this.disassociateAdditionalCodeRepositories(model.disassociateAdditionalCodeRepositories);
            this.rootAccess(model.rootAccess);
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getInstanceTypeAsString() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLifecycleConfigName() {
            return this.lifecycleConfigName;
        }

        @Override
        public final Builder lifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        public final void setLifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
        }

        public final Boolean getDisassociateLifecycleConfig() {
            return this.disassociateLifecycleConfig;
        }

        @Override
        public final Builder disassociateLifecycleConfig(Boolean disassociateLifecycleConfig) {
            this.disassociateLifecycleConfig = disassociateLifecycleConfig;
            return this;
        }

        public final void setDisassociateLifecycleConfig(Boolean disassociateLifecycleConfig) {
            this.disassociateLifecycleConfig = disassociateLifecycleConfig;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        public final String getDefaultCodeRepository() {
            return this.defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            return this.additionalCodeRepositories;
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String ... additionalCodeRepositories) {
            this.additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        public final Collection<String> getAcceleratorTypesAsStrings() {
            return this.acceleratorTypes;
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String ... acceleratorTypes) {
            this.acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final void setAcceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        public final Boolean getDisassociateAcceleratorTypes() {
            return this.disassociateAcceleratorTypes;
        }

        @Override
        public final Builder disassociateAcceleratorTypes(Boolean disassociateAcceleratorTypes) {
            this.disassociateAcceleratorTypes = disassociateAcceleratorTypes;
            return this;
        }

        public final void setDisassociateAcceleratorTypes(Boolean disassociateAcceleratorTypes) {
            this.disassociateAcceleratorTypes = disassociateAcceleratorTypes;
        }

        public final Boolean getDisassociateDefaultCodeRepository() {
            return this.disassociateDefaultCodeRepository;
        }

        @Override
        public final Builder disassociateDefaultCodeRepository(Boolean disassociateDefaultCodeRepository) {
            this.disassociateDefaultCodeRepository = disassociateDefaultCodeRepository;
            return this;
        }

        public final void setDisassociateDefaultCodeRepository(Boolean disassociateDefaultCodeRepository) {
            this.disassociateDefaultCodeRepository = disassociateDefaultCodeRepository;
        }

        public final Boolean getDisassociateAdditionalCodeRepositories() {
            return this.disassociateAdditionalCodeRepositories;
        }

        @Override
        public final Builder disassociateAdditionalCodeRepositories(Boolean disassociateAdditionalCodeRepositories) {
            this.disassociateAdditionalCodeRepositories = disassociateAdditionalCodeRepositories;
            return this;
        }

        public final void setDisassociateAdditionalCodeRepositories(Boolean disassociateAdditionalCodeRepositories) {
            this.disassociateAdditionalCodeRepositories = disassociateAdditionalCodeRepositories;
        }

        public final String getRootAccessAsString() {
            return this.rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess.toString());
            return this;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotebookInstanceRequest build() {
            return new UpdateNotebookInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNotebookInstanceRequest> {
        public Builder notebookInstanceName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder roleArn(String var1);

        public Builder lifecycleConfigName(String var1);

        public Builder disassociateLifecycleConfig(Boolean var1);

        public Builder volumeSizeInGB(Integer var1);

        public Builder defaultCodeRepository(String var1);

        public Builder additionalCodeRepositories(Collection<String> var1);

        public Builder additionalCodeRepositories(String ... var1);

        public Builder acceleratorTypesWithStrings(Collection<String> var1);

        public Builder acceleratorTypesWithStrings(String ... var1);

        public Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> var1);

        public Builder acceleratorTypes(NotebookInstanceAcceleratorType ... var1);

        public Builder disassociateAcceleratorTypes(Boolean var1);

        public Builder disassociateDefaultCodeRepository(Boolean var1);

        public Builder disassociateAdditionalCodeRepositories(Boolean var1);

        public Builder rootAccess(String var1);

        public Builder rootAccess(RootAccess var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

