/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TargetDevice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputConfig> {
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputConfig.getter(OutputConfig::s3OutputLocation)).setter(OutputConfig.setter(Builder::s3OutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()}).build();
    private static final SdkField<String> TARGET_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputConfig.getter(OutputConfig::targetDeviceAsString)).setter(OutputConfig.setter(Builder::targetDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDevice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_LOCATION_FIELD, TARGET_DEVICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3OutputLocation;
    private final String targetDevice;

    private OutputConfig(BuilderImpl builder) {
        this.s3OutputLocation = builder.s3OutputLocation;
        this.targetDevice = builder.targetDevice;
    }

    public String s3OutputLocation() {
        return this.s3OutputLocation;
    }

    public TargetDevice targetDevice() {
        return TargetDevice.fromValue(this.targetDevice);
    }

    public String targetDeviceAsString() {
        return this.targetDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDeviceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        return Objects.equals(this.s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(this.targetDeviceAsString(), other.targetDeviceAsString());
    }

    public String toString() {
        return ToString.builder((String)"OutputConfig").add("S3OutputLocation", (Object)this.s3OutputLocation()).add("TargetDevice", (Object)this.targetDeviceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.s3OutputLocation()));
            }
            case "TargetDevice": {
                return Optional.ofNullable(clazz.cast(this.targetDeviceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputConfig, T> g) {
        return obj -> g.apply((OutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputLocation;
        private String targetDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConfig model) {
            this.s3OutputLocation(model.s3OutputLocation);
            this.targetDevice(model.targetDevice);
        }

        public final String getS3OutputLocation() {
            return this.s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        public final String getTargetDeviceAsString() {
            return this.targetDevice;
        }

        @Override
        public final Builder targetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
            return this;
        }

        @Override
        public final Builder targetDevice(TargetDevice targetDevice) {
            this.targetDevice(targetDevice.toString());
            return this;
        }

        public final void setTargetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
        }

        public OutputConfig build() {
            return new OutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputConfig> {
        public Builder s3OutputLocation(String var1);

        public Builder targetDevice(String var1);

        public Builder targetDevice(TargetDevice var1);
    }
}

