/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.GitConfigForUpdate;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCodeRepositoryRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateCodeRepositoryRequest> {
    private static final SdkField<String> CODE_REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCodeRepositoryRequest.getter(UpdateCodeRepositoryRequest::codeRepositoryName)).setter(UpdateCodeRepositoryRequest.setter(Builder::codeRepositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryName").build()}).build();
    private static final SdkField<GitConfigForUpdate> GIT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateCodeRepositoryRequest.getter(UpdateCodeRepositoryRequest::gitConfig)).setter(UpdateCodeRepositoryRequest.setter(Builder::gitConfig)).constructor(GitConfigForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_NAME_FIELD, GIT_CONFIG_FIELD));
    private final String codeRepositoryName;
    private final GitConfigForUpdate gitConfig;

    private UpdateCodeRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.codeRepositoryName = builder.codeRepositoryName;
        this.gitConfig = builder.gitConfig;
    }

    public String codeRepositoryName() {
        return this.codeRepositoryName;
    }

    public GitConfigForUpdate gitConfig() {
        return this.gitConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCodeRepositoryRequest)) {
            return false;
        }
        UpdateCodeRepositoryRequest other = (UpdateCodeRepositoryRequest)((Object)obj);
        return Objects.equals(this.codeRepositoryName(), other.codeRepositoryName()) && Objects.equals(this.gitConfig(), other.gitConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCodeRepositoryRequest").add("CodeRepositoryName", (Object)this.codeRepositoryName()).add("GitConfig", (Object)this.gitConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeRepositoryName": {
                return Optional.ofNullable(clazz.cast(this.codeRepositoryName()));
            }
            case "GitConfig": {
                return Optional.ofNullable(clazz.cast(this.gitConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCodeRepositoryRequest, T> g) {
        return obj -> g.apply((UpdateCodeRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String codeRepositoryName;
        private GitConfigForUpdate gitConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCodeRepositoryRequest model) {
            super(model);
            this.codeRepositoryName(model.codeRepositoryName);
            this.gitConfig(model.gitConfig);
        }

        public final String getCodeRepositoryName() {
            return this.codeRepositoryName;
        }

        @Override
        public final Builder codeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        public final void setCodeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
        }

        public final GitConfigForUpdate.Builder getGitConfig() {
            return this.gitConfig != null ? this.gitConfig.toBuilder() : null;
        }

        @Override
        public final Builder gitConfig(GitConfigForUpdate gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        public final void setGitConfig(GitConfigForUpdate.BuilderImpl gitConfig) {
            this.gitConfig = gitConfig != null ? gitConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCodeRepositoryRequest build() {
            return new UpdateCodeRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCodeRepositoryRequest> {
        public Builder codeRepositoryName(String var1);

        public Builder gitConfig(GitConfigForUpdate var1);

        default public Builder gitConfig(Consumer<GitConfigForUpdate.Builder> gitConfig) {
            return this.gitConfig((GitConfigForUpdate)((GitConfigForUpdate.Builder)GitConfigForUpdate.builder().applyMutation(gitConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

