/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ResourceType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SuggestionQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSearchSuggestionsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, GetSearchSuggestionsRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSearchSuggestionsRequest.getter(GetSearchSuggestionsRequest::resourceAsString)).setter(GetSearchSuggestionsRequest.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<SuggestionQuery> SUGGESTION_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetSearchSuggestionsRequest.getter(GetSearchSuggestionsRequest::suggestionQuery)).setter(GetSearchSuggestionsRequest.setter(Builder::suggestionQuery)).constructor(SuggestionQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, SUGGESTION_QUERY_FIELD));
    private final String resource;
    private final SuggestionQuery suggestionQuery;

    private GetSearchSuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.suggestionQuery = builder.suggestionQuery;
    }

    public ResourceType resource() {
        return ResourceType.fromValue(this.resource);
    }

    public String resourceAsString() {
        return this.resource;
    }

    public SuggestionQuery suggestionQuery() {
        return this.suggestionQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestionQuery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchSuggestionsRequest)) {
            return false;
        }
        GetSearchSuggestionsRequest other = (GetSearchSuggestionsRequest)((Object)obj);
        return Objects.equals(this.resourceAsString(), other.resourceAsString()) && Objects.equals(this.suggestionQuery(), other.suggestionQuery());
    }

    public String toString() {
        return ToString.builder((String)"GetSearchSuggestionsRequest").add("Resource", (Object)this.resourceAsString()).add("SuggestionQuery", (Object)this.suggestionQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resourceAsString()));
            }
            case "SuggestionQuery": {
                return Optional.ofNullable(clazz.cast(this.suggestionQuery()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSearchSuggestionsRequest, T> g) {
        return obj -> g.apply((GetSearchSuggestionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String resource;
        private SuggestionQuery suggestionQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchSuggestionsRequest model) {
            super(model);
            this.resource(model.resource);
            this.suggestionQuery(model.suggestionQuery);
        }

        public final String getResourceAsString() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public final Builder resource(ResourceType resource) {
            this.resource(resource.toString());
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final SuggestionQuery.Builder getSuggestionQuery() {
            return this.suggestionQuery != null ? this.suggestionQuery.toBuilder() : null;
        }

        @Override
        public final Builder suggestionQuery(SuggestionQuery suggestionQuery) {
            this.suggestionQuery = suggestionQuery;
            return this;
        }

        public final void setSuggestionQuery(SuggestionQuery.BuilderImpl suggestionQuery) {
            this.suggestionQuery = suggestionQuery != null ? suggestionQuery.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSearchSuggestionsRequest build() {
            return new GetSearchSuggestionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSearchSuggestionsRequest> {
        public Builder resource(String var1);

        public Builder resource(ResourceType var1);

        public Builder suggestionQuery(SuggestionQuery var1);

        default public Builder suggestionQuery(Consumer<SuggestionQuery.Builder> suggestionQuery) {
            return this.suggestionQuery((SuggestionQuery)((SuggestionQuery.Builder)SuggestionQuery.builder().applyMutation(suggestionQuery)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

