/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityInstanceType;
import software.amazon.awssdk.services.sagemaker.model.UltraServerHealthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UltraServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UltraServer> {
    private static final SdkField<String> ULTRA_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UltraServerId").getter(UltraServer.getter(UltraServer::ultraServerId)).setter(UltraServer.setter(Builder::ultraServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerId").build()}).build();
    private static final SdkField<String> ULTRA_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UltraServerType").getter(UltraServer.getter(UltraServer::ultraServerType)).setter(UltraServer.setter(Builder::ultraServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(UltraServer.getter(UltraServer::availabilityZone)).setter(UltraServer.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(UltraServer.getter(UltraServer::instanceTypeAsString)).setter(UltraServer.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(UltraServer.getter(UltraServer::totalInstanceCount)).setter(UltraServer.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build()}).build();
    private static final SdkField<Integer> CONFIGURED_SPARE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConfiguredSpareInstanceCount").getter(UltraServer.getter(UltraServer::configuredSpareInstanceCount)).setter(UltraServer.setter(Builder::configuredSpareInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfiguredSpareInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(UltraServer.getter(UltraServer::availableInstanceCount)).setter(UltraServer.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build()}).build();
    private static final SdkField<Integer> IN_USE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InUseInstanceCount").getter(UltraServer.getter(UltraServer::inUseInstanceCount)).setter(UltraServer.setter(Builder::inUseInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_SPARE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableSpareInstanceCount").getter(UltraServer.getter(UltraServer::availableSpareInstanceCount)).setter(UltraServer.setter(Builder::availableSpareInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSpareInstanceCount").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnhealthyInstanceCount").getter(UltraServer.getter(UltraServer::unhealthyInstanceCount)).setter(UltraServer.setter(Builder::unhealthyInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyInstanceCount").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(UltraServer.getter(UltraServer::healthStatusAsString)).setter(UltraServer.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ULTRA_SERVER_ID_FIELD, ULTRA_SERVER_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, CONFIGURED_SPARE_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, IN_USE_INSTANCE_COUNT_FIELD, AVAILABLE_SPARE_INSTANCE_COUNT_FIELD, UNHEALTHY_INSTANCE_COUNT_FIELD, HEALTH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UltraServer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ultraServerId;
    private final String ultraServerType;
    private final String availabilityZone;
    private final String instanceType;
    private final Integer totalInstanceCount;
    private final Integer configuredSpareInstanceCount;
    private final Integer availableInstanceCount;
    private final Integer inUseInstanceCount;
    private final Integer availableSpareInstanceCount;
    private final Integer unhealthyInstanceCount;
    private final String healthStatus;

    private UltraServer(BuilderImpl builder) {
        this.ultraServerId = builder.ultraServerId;
        this.ultraServerType = builder.ultraServerType;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.configuredSpareInstanceCount = builder.configuredSpareInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.inUseInstanceCount = builder.inUseInstanceCount;
        this.availableSpareInstanceCount = builder.availableSpareInstanceCount;
        this.unhealthyInstanceCount = builder.unhealthyInstanceCount;
        this.healthStatus = builder.healthStatus;
    }

    public final String ultraServerId() {
        return this.ultraServerId;
    }

    public final String ultraServerType() {
        return this.ultraServerType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer configuredSpareInstanceCount() {
        return this.configuredSpareInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Integer inUseInstanceCount() {
        return this.inUseInstanceCount;
    }

    public final Integer availableSpareInstanceCount() {
        return this.availableSpareInstanceCount;
    }

    public final Integer unhealthyInstanceCount() {
        return this.unhealthyInstanceCount;
    }

    public final UltraServerHealthStatus healthStatus() {
        return UltraServerHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredSpareInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableSpareInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UltraServer)) {
            return false;
        }
        UltraServer other = (UltraServer)obj;
        return Objects.equals(this.ultraServerId(), other.ultraServerId()) && Objects.equals(this.ultraServerType(), other.ultraServerType()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.configuredSpareInstanceCount(), other.configuredSpareInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.inUseInstanceCount(), other.inUseInstanceCount()) && Objects.equals(this.availableSpareInstanceCount(), other.availableSpareInstanceCount()) && Objects.equals(this.unhealthyInstanceCount(), other.unhealthyInstanceCount()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UltraServer").add("UltraServerId", (Object)this.ultraServerId()).add("UltraServerType", (Object)this.ultraServerType()).add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceType", (Object)this.instanceTypeAsString()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("ConfiguredSpareInstanceCount", (Object)this.configuredSpareInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("InUseInstanceCount", (Object)this.inUseInstanceCount()).add("AvailableSpareInstanceCount", (Object)this.availableSpareInstanceCount()).add("UnhealthyInstanceCount", (Object)this.unhealthyInstanceCount()).add("HealthStatus", (Object)this.healthStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UltraServerId": {
                return Optional.ofNullable(clazz.cast(this.ultraServerId()));
            }
            case "UltraServerType": {
                return Optional.ofNullable(clazz.cast(this.ultraServerType()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "ConfiguredSpareInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.configuredSpareInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "InUseInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.inUseInstanceCount()));
            }
            case "AvailableSpareInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableSpareInstanceCount()));
            }
            case "UnhealthyInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.unhealthyInstanceCount()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UltraServerId", ULTRA_SERVER_ID_FIELD);
        map.put("UltraServerType", ULTRA_SERVER_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("ConfiguredSpareInstanceCount", CONFIGURED_SPARE_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("InUseInstanceCount", IN_USE_INSTANCE_COUNT_FIELD);
        map.put("AvailableSpareInstanceCount", AVAILABLE_SPARE_INSTANCE_COUNT_FIELD);
        map.put("UnhealthyInstanceCount", UNHEALTHY_INSTANCE_COUNT_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UltraServer, T> g) {
        return obj -> g.apply((UltraServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ultraServerId;
        private String ultraServerType;
        private String availabilityZone;
        private String instanceType;
        private Integer totalInstanceCount;
        private Integer configuredSpareInstanceCount;
        private Integer availableInstanceCount;
        private Integer inUseInstanceCount;
        private Integer availableSpareInstanceCount;
        private Integer unhealthyInstanceCount;
        private String healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UltraServer model) {
            this.ultraServerId(model.ultraServerId);
            this.ultraServerType(model.ultraServerType);
            this.availabilityZone(model.availabilityZone);
            this.instanceType(model.instanceType);
            this.totalInstanceCount(model.totalInstanceCount);
            this.configuredSpareInstanceCount(model.configuredSpareInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.inUseInstanceCount(model.inUseInstanceCount);
            this.availableSpareInstanceCount(model.availableSpareInstanceCount);
            this.unhealthyInstanceCount(model.unhealthyInstanceCount);
            this.healthStatus(model.healthStatus);
        }

        public final String getUltraServerId() {
            return this.ultraServerId;
        }

        public final void setUltraServerId(String ultraServerId) {
            this.ultraServerId = ultraServerId;
        }

        @Override
        public final Builder ultraServerId(String ultraServerId) {
            this.ultraServerId = ultraServerId;
            return this;
        }

        public final String getUltraServerType() {
            return this.ultraServerType;
        }

        public final void setUltraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
        }

        @Override
        public final Builder ultraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getConfiguredSpareInstanceCount() {
            return this.configuredSpareInstanceCount;
        }

        public final void setConfiguredSpareInstanceCount(Integer configuredSpareInstanceCount) {
            this.configuredSpareInstanceCount = configuredSpareInstanceCount;
        }

        @Override
        public final Builder configuredSpareInstanceCount(Integer configuredSpareInstanceCount) {
            this.configuredSpareInstanceCount = configuredSpareInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getInUseInstanceCount() {
            return this.inUseInstanceCount;
        }

        public final void setInUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
        }

        @Override
        public final Builder inUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
            return this;
        }

        public final Integer getAvailableSpareInstanceCount() {
            return this.availableSpareInstanceCount;
        }

        public final void setAvailableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
        }

        @Override
        public final Builder availableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
            return this;
        }

        public final Integer getUnhealthyInstanceCount() {
            return this.unhealthyInstanceCount;
        }

        public final void setUnhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
        }

        @Override
        public final Builder unhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(UltraServerHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public UltraServer build() {
            return new UltraServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UltraServer> {
        public Builder ultraServerId(String var1);

        public Builder ultraServerType(String var1);

        public Builder availabilityZone(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ReservedCapacityInstanceType var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder configuredSpareInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder inUseInstanceCount(Integer var1);

        public Builder availableSpareInstanceCount(Integer var1);

        public Builder unhealthyInstanceCount(Integer var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(UltraServerHealthStatus var1);
    }
}

