/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.GroupPatternsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleGroupAssignment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoleGroupAssignment> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(RoleGroupAssignment.getter(RoleGroupAssignment::roleName)).setter(RoleGroupAssignment.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<List<String>> GROUP_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupPatterns").getter(RoleGroupAssignment.getter(RoleGroupAssignment::groupPatterns)).setter(RoleGroupAssignment.setter(Builder::groupPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD, GROUP_PATTERNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoleGroupAssignment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleName;
    private final List<String> groupPatterns;

    private RoleGroupAssignment(BuilderImpl builder) {
        this.roleName = builder.roleName;
        this.groupPatterns = builder.groupPatterns;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final boolean hasGroupPatterns() {
        return this.groupPatterns != null && !(this.groupPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> groupPatterns() {
        return this.groupPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupPatterns() ? this.groupPatterns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleGroupAssignment)) {
            return false;
        }
        RoleGroupAssignment other = (RoleGroupAssignment)obj;
        return Objects.equals(this.roleName(), other.roleName()) && this.hasGroupPatterns() == other.hasGroupPatterns() && Objects.equals(this.groupPatterns(), other.groupPatterns());
    }

    public final String toString() {
        return ToString.builder((String)"RoleGroupAssignment").add("RoleName", (Object)this.roleName()).add("GroupPatterns", this.hasGroupPatterns() ? this.groupPatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "GroupPatterns": {
                return Optional.ofNullable(clazz.cast(this.groupPatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("GroupPatterns", GROUP_PATTERNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoleGroupAssignment, T> g) {
        return obj -> g.apply((RoleGroupAssignment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleName;
        private List<String> groupPatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoleGroupAssignment model) {
            this.roleName(model.roleName);
            this.groupPatterns(model.groupPatterns);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final Collection<String> getGroupPatterns() {
            if (this.groupPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupPatterns;
        }

        public final void setGroupPatterns(Collection<String> groupPatterns) {
            this.groupPatterns = GroupPatternsListCopier.copy(groupPatterns);
        }

        @Override
        public final Builder groupPatterns(Collection<String> groupPatterns) {
            this.groupPatterns = GroupPatternsListCopier.copy(groupPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupPatterns(String ... groupPatterns) {
            this.groupPatterns(Arrays.asList(groupPatterns));
            return this;
        }

        public RoleGroupAssignment build() {
            return new RoleGroupAssignment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoleGroupAssignment> {
        public Builder roleName(String var1);

        public Builder groupPatterns(Collection<String> var1);

        public Builder groupPatterns(String ... var1);
    }
}

