/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityStatus;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedCapacitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedCapacitySummary> {
    private static final SdkField<String> RESERVED_CAPACITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCapacityArn").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::reservedCapacityArn)).setter(ReservedCapacitySummary.setter(Builder::reservedCapacityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityArn").build()}).build();
    private static final SdkField<String> RESERVED_CAPACITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCapacityType").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::reservedCapacityTypeAsString)).setter(ReservedCapacitySummary.setter(Builder::reservedCapacityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityType").build()}).build();
    private static final SdkField<String> ULTRA_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UltraServerType").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::ultraServerType)).setter(ReservedCapacitySummary.setter(Builder::ultraServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerType").build()}).build();
    private static final SdkField<Integer> ULTRA_SERVER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UltraServerCount").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::ultraServerCount)).setter(ReservedCapacitySummary.setter(Builder::ultraServerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::instanceTypeAsString)).setter(ReservedCapacitySummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::totalInstanceCount)).setter(ReservedCapacitySummary.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::statusAsString)).setter(ReservedCapacitySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::availabilityZone)).setter(ReservedCapacitySummary.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationHours").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::durationHours)).setter(ReservedCapacitySummary.setter(Builder::durationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()}).build();
    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMinutes").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::durationMinutes)).setter(ReservedCapacitySummary.setter(Builder::durationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::startTime)).setter(ReservedCapacitySummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ReservedCapacitySummary.getter(ReservedCapacitySummary::endTime)).setter(ReservedCapacitySummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CAPACITY_ARN_FIELD, RESERVED_CAPACITY_TYPE_FIELD, ULTRA_SERVER_TYPE_FIELD, ULTRA_SERVER_COUNT_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, STATUS_FIELD, AVAILABILITY_ZONE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedCapacitySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reservedCapacityArn;
    private final String reservedCapacityType;
    private final String ultraServerType;
    private final Integer ultraServerCount;
    private final String instanceType;
    private final Integer totalInstanceCount;
    private final String status;
    private final String availabilityZone;
    private final Long durationHours;
    private final Long durationMinutes;
    private final Instant startTime;
    private final Instant endTime;

    private ReservedCapacitySummary(BuilderImpl builder) {
        this.reservedCapacityArn = builder.reservedCapacityArn;
        this.reservedCapacityType = builder.reservedCapacityType;
        this.ultraServerType = builder.ultraServerType;
        this.ultraServerCount = builder.ultraServerCount;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.status = builder.status;
        this.availabilityZone = builder.availabilityZone;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String reservedCapacityArn() {
        return this.reservedCapacityArn;
    }

    public final ReservedCapacityType reservedCapacityType() {
        return ReservedCapacityType.fromValue(this.reservedCapacityType);
    }

    public final String reservedCapacityTypeAsString() {
        return this.reservedCapacityType;
    }

    public final String ultraServerType() {
        return this.ultraServerType;
    }

    public final Integer ultraServerCount() {
        return this.ultraServerCount;
    }

    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final ReservedCapacityStatus status() {
        return ReservedCapacityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long durationHours() {
        return this.durationHours;
    }

    public final Long durationMinutes() {
        return this.durationMinutes;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCapacityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCapacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCapacitySummary)) {
            return false;
        }
        ReservedCapacitySummary other = (ReservedCapacitySummary)obj;
        return Objects.equals(this.reservedCapacityArn(), other.reservedCapacityArn()) && Objects.equals(this.reservedCapacityTypeAsString(), other.reservedCapacityTypeAsString()) && Objects.equals(this.ultraServerType(), other.ultraServerType()) && Objects.equals(this.ultraServerCount(), other.ultraServerCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.durationHours(), other.durationHours()) && Objects.equals(this.durationMinutes(), other.durationMinutes()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedCapacitySummary").add("ReservedCapacityArn", (Object)this.reservedCapacityArn()).add("ReservedCapacityType", (Object)this.reservedCapacityTypeAsString()).add("UltraServerType", (Object)this.ultraServerType()).add("UltraServerCount", (Object)this.ultraServerCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("Status", (Object)this.statusAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("DurationHours", (Object)this.durationHours()).add("DurationMinutes", (Object)this.durationMinutes()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedCapacityArn": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacityArn()));
            }
            case "ReservedCapacityType": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacityTypeAsString()));
            }
            case "UltraServerType": {
                return Optional.ofNullable(clazz.cast(this.ultraServerType()));
            }
            case "UltraServerCount": {
                return Optional.ofNullable(clazz.cast(this.ultraServerCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DurationHours": {
                return Optional.ofNullable(clazz.cast(this.durationHours()));
            }
            case "DurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.durationMinutes()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedCapacityArn", RESERVED_CAPACITY_ARN_FIELD);
        map.put("ReservedCapacityType", RESERVED_CAPACITY_TYPE_FIELD);
        map.put("UltraServerType", ULTRA_SERVER_TYPE_FIELD);
        map.put("UltraServerCount", ULTRA_SERVER_COUNT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedCapacitySummary, T> g) {
        return obj -> g.apply((ReservedCapacitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedCapacityArn;
        private String reservedCapacityType;
        private String ultraServerType;
        private Integer ultraServerCount;
        private String instanceType;
        private Integer totalInstanceCount;
        private String status;
        private String availabilityZone;
        private Long durationHours;
        private Long durationMinutes;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCapacitySummary model) {
            this.reservedCapacityArn(model.reservedCapacityArn);
            this.reservedCapacityType(model.reservedCapacityType);
            this.ultraServerType(model.ultraServerType);
            this.ultraServerCount(model.ultraServerCount);
            this.instanceType(model.instanceType);
            this.totalInstanceCount(model.totalInstanceCount);
            this.status(model.status);
            this.availabilityZone(model.availabilityZone);
            this.durationHours(model.durationHours);
            this.durationMinutes(model.durationMinutes);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getReservedCapacityArn() {
            return this.reservedCapacityArn;
        }

        public final void setReservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
        }

        @Override
        public final Builder reservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
            return this;
        }

        public final String getReservedCapacityType() {
            return this.reservedCapacityType;
        }

        public final void setReservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
        }

        @Override
        public final Builder reservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
            return this;
        }

        @Override
        public final Builder reservedCapacityType(ReservedCapacityType reservedCapacityType) {
            this.reservedCapacityType(reservedCapacityType == null ? null : reservedCapacityType.toString());
            return this;
        }

        public final String getUltraServerType() {
            return this.ultraServerType;
        }

        public final void setUltraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
        }

        @Override
        public final Builder ultraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
            return this;
        }

        public final Integer getUltraServerCount() {
            return this.ultraServerCount;
        }

        public final void setUltraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
        }

        @Override
        public final Builder ultraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservedCapacityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDurationHours() {
            return this.durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return this.durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public ReservedCapacitySummary build() {
            return new ReservedCapacitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedCapacitySummary> {
        public Builder reservedCapacityArn(String var1);

        public Builder reservedCapacityType(String var1);

        public Builder reservedCapacityType(ReservedCapacityType var1);

        public Builder ultraServerType(String var1);

        public Builder ultraServerCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ReservedCapacityInstanceType var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder status(String var1);

        public Builder status(ReservedCapacityStatus var1);

        public Builder availabilityZone(String var1);

        public Builder durationHours(Long var1);

        public Builder durationMinutes(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

