/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UltraServer;
import software.amazon.awssdk.services.sagemaker.model.UltraServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUltraServersByReservedCapacityResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListUltraServersByReservedCapacityResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUltraServersByReservedCapacityResponse.getter(ListUltraServersByReservedCapacityResponse::nextToken)).setter(ListUltraServersByReservedCapacityResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<UltraServer>> ULTRA_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UltraServers").getter(ListUltraServersByReservedCapacityResponse.getter(ListUltraServersByReservedCapacityResponse::ultraServers)).setter(ListUltraServersByReservedCapacityResponse.setter(Builder::ultraServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UltraServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ULTRA_SERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUltraServersByReservedCapacityResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<UltraServer> ultraServers;

    private ListUltraServersByReservedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ultraServers = builder.ultraServers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUltraServers() {
        return this.ultraServers != null && !(this.ultraServers instanceof SdkAutoConstructList);
    }

    public final List<UltraServer> ultraServers() {
        return this.ultraServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUltraServers() ? this.ultraServers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUltraServersByReservedCapacityResponse)) {
            return false;
        }
        ListUltraServersByReservedCapacityResponse other = (ListUltraServersByReservedCapacityResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasUltraServers() == other.hasUltraServers() && Objects.equals(this.ultraServers(), other.ultraServers());
    }

    public final String toString() {
        return ToString.builder((String)"ListUltraServersByReservedCapacityResponse").add("NextToken", (Object)this.nextToken()).add("UltraServers", this.hasUltraServers() ? this.ultraServers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "UltraServers": {
                return Optional.ofNullable(clazz.cast(this.ultraServers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("UltraServers", ULTRA_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUltraServersByReservedCapacityResponse, T> g) {
        return obj -> g.apply((ListUltraServersByReservedCapacityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UltraServer> ultraServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUltraServersByReservedCapacityResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ultraServers(model.ultraServers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UltraServer.Builder> getUltraServers() {
            List<UltraServer.Builder> result = UltraServersCopier.copyToBuilder(this.ultraServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUltraServers(Collection<UltraServer.BuilderImpl> ultraServers) {
            this.ultraServers = UltraServersCopier.copyFromBuilder(ultraServers);
        }

        @Override
        public final Builder ultraServers(Collection<UltraServer> ultraServers) {
            this.ultraServers = UltraServersCopier.copy(ultraServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ultraServers(UltraServer ... ultraServers) {
            this.ultraServers(Arrays.asList(ultraServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ultraServers(Consumer<UltraServer.Builder> ... ultraServers) {
            this.ultraServers(Stream.of(ultraServers).map(c -> (UltraServer)((UltraServer.Builder)UltraServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUltraServersByReservedCapacityResponse build() {
            return new ListUltraServersByReservedCapacityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUltraServersByReservedCapacityResponse> {
        public Builder nextToken(String var1);

        public Builder ultraServers(Collection<UltraServer> var1);

        public Builder ultraServers(UltraServer ... var1);

        public Builder ultraServers(Consumer<UltraServer.Builder> ... var1);
    }
}

